/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.UserProfilePhotos;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class GetUserProfilePhotos
extends BotApiMethod<UserProfilePhotos> {
    public static final String PATH = "getuserprofilephotos";
    private static final String USERID_FIELD = "user_id";
    private static final String OFFSET_FIELD = "offset";
    private static final String LIMIT_FIELD = "limit";
    private Integer userId;
    private Integer offset;
    private Integer limit;

    public Integer getUserId() {
        return this.userId;
    }

    public GetUserProfilePhotos setUserId(Integer userId) {
        this.userId = userId;
        return this;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public GetUserProfilePhotos setOffset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public GetUserProfilePhotos setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(USERID_FIELD, this.userId);
        jsonObject.put(OFFSET_FIELD, this.offset);
        if (this.limit != null) {
            jsonObject.put(LIMIT_FIELD, this.limit);
        }
        return jsonObject;
    }

    @Override
    public String getPath() {
        return PATH;
    }

    @Override
    public UserProfilePhotos deserializeResponse(JSONObject answer) {
        if (answer.getBoolean("ok")) {
            return new UserProfilePhotos(answer.getJSONObject("result"));
        }
        return null;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.userId == null) {
            throw new TelegramApiValidationException("UserId parameter can't be empty", this);
        }
        if (this.offset == null) {
            throw new TelegramApiValidationException("Offset parameter can't be empty", this);
        }
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("method", PATH);
        gen.writeNumberField(USERID_FIELD, this.userId);
        gen.writeNumberField(OFFSET_FIELD, this.offset);
        if (this.limit != null) {
            gen.writeNumberField(LIMIT_FIELD, this.limit);
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "GetUserProfilePhotos{userId=" + this.userId + ", offset=" + this.offset + ", limit=" + this.limit + '}';
    }
}

