/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.games;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.games.GameHighScore;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class GetGameHighScores
extends BotApiMethod<ArrayList<GameHighScore>> {
    public static final String PATH = "getGameHighScores";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MESSAGEID_FIELD = "message_id";
    private static final String INLINE_MESSAGE_ID_FIELD = "inline_message_id";
    private static final String USER_ID_FIELD = "user_id";
    private String chatId;
    private Integer messageId;
    private String inlineMessageId;
    private Integer userId;

    public String getChatId() {
        return this.chatId;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public GetGameHighScores setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public GetGameHighScores setMessageId(Integer messageId) {
        this.messageId = messageId;
        return this;
    }

    public GetGameHighScores setInlineMessageId(String inlineMessageId) {
        this.inlineMessageId = inlineMessageId;
        return this;
    }

    public GetGameHighScores setUserId(Integer userId) {
        this.userId = userId;
        return this;
    }

    @Override
    public String getPath() {
        return PATH;
    }

    @Override
    public ArrayList<GameHighScore> deserializeResponse(JSONObject answer) {
        if (answer.getBoolean("ok")) {
            JSONArray highScores = answer.getJSONArray("result");
            ArrayList<GameHighScore> scores = new ArrayList<GameHighScore>();
            for (int i = 0; i < highScores.length(); ++i) {
                scores.add(new GameHighScore(highScores.getJSONObject(i)));
            }
            return scores;
        }
        return null;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.userId == null) {
            throw new TelegramApiValidationException("UserId parameter can't be empty", this);
        }
        if (this.inlineMessageId == null) {
            if (this.chatId == null) {
                throw new TelegramApiValidationException("ChatId parameter can't be empty if inlineMessageId is not present", this);
            }
            if (this.messageId == null) {
                throw new TelegramApiValidationException("MessageId parameter can't be empty if inlineMessageId is not present", this);
            }
        } else {
            if (this.chatId != null) {
                throw new TelegramApiValidationException("ChatId parameter must be empty if inlineMessageId is provided", this);
            }
            if (this.messageId != null) {
                throw new TelegramApiValidationException("MessageId parameter must be empty if inlineMessageId is provided", this);
            }
        }
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        if (this.chatId != null) {
            gen.writeStringField(CHATID_FIELD, this.chatId);
            gen.writeNumberField(MESSAGEID_FIELD, this.messageId);
        }
        if (this.inlineMessageId != null) {
            gen.writeStringField(INLINE_MESSAGE_ID_FIELD, this.inlineMessageId);
        }
        gen.writeNumberField(USER_ID_FIELD, this.userId);
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        if (this.chatId != null) {
            jsonObject.put(CHATID_FIELD, this.chatId);
            jsonObject.put(MESSAGEID_FIELD, this.messageId);
        }
        if (this.inlineMessageId != null) {
            jsonObject.put(INLINE_MESSAGE_ID_FIELD, this.inlineMessageId);
        }
        jsonObject.put(USER_ID_FIELD, this.userId);
        return jsonObject;
    }

    public String toString() {
        return "GetGameHighScores{chatId='" + this.chatId + '\'' + ", messageId=" + this.messageId + ", inlineMessageId='" + this.inlineMessageId + '\'' + ", userId=" + this.userId + '}';
    }
}

