/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.groupadministration;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.ChatMember;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class GetChatMember
extends BotApiMethod<ChatMember> {
    public static final String PATH = "getChatMember";
    private static final String CHATID_FIELD = "chat_id";
    private static final String USERID_FIELD = "user_id";
    private String chatId;
    private Integer userId;

    public String getChatId() {
        return this.chatId;
    }

    public GetChatMember setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public GetChatMember setUserId(Integer userId) {
        this.userId = userId;
        return this;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(CHATID_FIELD, this.chatId);
        jsonObject.put(USERID_FIELD, this.userId);
        return jsonObject;
    }

    @Override
    public String getPath() {
        return PATH;
    }

    @Override
    public ChatMember deserializeResponse(JSONObject answer) {
        if (answer.getBoolean("ok")) {
            return new ChatMember(answer.getJSONObject("result"));
        }
        return null;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId can't be null", this);
        }
        if (this.userId == null) {
            throw new TelegramApiValidationException("UserId can't be null", this);
        }
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("method", PATH);
        gen.writeStringField(CHATID_FIELD, this.chatId);
        gen.writeNumberField(USERID_FIELD, this.userId);
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "GetChatMember{chatId='" + this.chatId + '\'' + ", userId='" + this.userId + '\'' + '}';
    }
}

