/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.send;

import java.io.File;
import java.io.InputStream;
import java.util.Objects;
import org.telegram.telegrambots.api.objects.replykeyboard.ReplyKeyboard;

public class SendAudio {
    public static final String PATH = "sendaudio";
    public static final String DURATION_FIELD = "duration";
    public static final String CHATID_FIELD = "chat_id";
    public static final String AUDIO_FIELD = "audio";
    public static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    public static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    public static final String REPLYMARKUP_FIELD = "reply_markup";
    public static final String PERFOMER_FIELD = "performer";
    public static final String TITLE_FIELD = "title";
    public static final String CAPTION_FIELD = "caption";
    private Integer duration;
    private String chatId;
    private String audio;
    private Integer replyToMessageId;
    private Boolean disableNotification;
    private ReplyKeyboard replyMarkup;
    private String performer;
    private String title;
    private String caption;
    private boolean isNewAudio;
    private String audioName;
    private File newAudioFile;
    private InputStream newAudioStream;

    public Integer getDuration() {
        return this.duration;
    }

    public SendAudio setDuration(Integer duration) {
        this.duration = duration;
        return this;
    }

    public String getChatId() {
        return this.chatId;
    }

    public SendAudio setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public String getAudio() {
        return this.audio;
    }

    public SendAudio setAudio(String audio) {
        this.audio = audio;
        this.isNewAudio = false;
        return this;
    }

    public SendAudio setNewAudio(File file) {
        this.audio = file.getName();
        this.isNewAudio = true;
        this.newAudioFile = file;
        return this;
    }

    public SendAudio setNewAudio(String audioName, InputStream inputStream) {
        Objects.requireNonNull(audioName, "audioName cannot be null!");
        Objects.requireNonNull(inputStream, "inputStream cannot be null!");
        this.audioName = audioName;
        this.isNewAudio = true;
        this.newAudioStream = inputStream;
        return this;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public SendAudio setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
        return this;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public SendAudio setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public String getPerformer() {
        return this.performer;
    }

    public SendAudio setPerformer(String performer) {
        this.performer = performer;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public SendAudio setTitle(String title) {
        this.title = title;
        return this;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public SendAudio enableNotification() {
        this.disableNotification = false;
        return this;
    }

    public SendAudio disableNotification() {
        this.disableNotification = true;
        return this;
    }

    public boolean isNewAudio() {
        return this.isNewAudio;
    }

    public String getAudioName() {
        return this.audioName;
    }

    public File getNewAudioFile() {
        return this.newAudioFile;
    }

    public InputStream getNewAudioStream() {
        return this.newAudioStream;
    }

    public String getCaption() {
        return this.caption;
    }

    public SendAudio setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    public String toString() {
        return "SendAudio{duration=" + this.duration + ", chatId='" + this.chatId + '\'' + ", audio='" + this.audio + '\'' + ", replyToMessageId=" + this.replyToMessageId + ", disableNotification=" + this.disableNotification + ", replyMarkup=" + this.replyMarkup + ", performer='" + this.performer + '\'' + ", title='" + this.title + '\'' + ", isNewAudio=" + this.isNewAudio + ", audioName='" + this.audioName + '\'' + ", newAudioFile=" + this.newAudioFile + ", newAudioStream=" + this.newAudioStream + ", caption='" + this.caption + '\'' + '}';
    }
}

