/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.send;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.methods.ActionType;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class SendChatAction
extends BotApiMethod<Boolean> {
    public static final String PATH = "sendChatAction";
    public static final String CHATID_FIELD = "chat_id";
    public static final String ACTION_FIELD = "action";
    private String chatId;
    private ActionType action;

    public String getChatId() {
        return this.chatId;
    }

    public SendChatAction setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public void setAction(ActionType action) {
        this.action = action;
    }

    @Override
    public String getPath() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(JSONObject answer) {
        if (answer.getBoolean("ok")) {
            return answer.getBoolean("result");
        }
        return null;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.action == null) {
            throw new TelegramApiValidationException("Action parameter can't be empty", this);
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(CHATID_FIELD, this.chatId);
        jsonObject.put(ACTION_FIELD, (Object)this.action);
        return jsonObject;
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(CHATID_FIELD, this.chatId);
        gen.writeStringField(ACTION_FIELD, this.action.toString());
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "SendChatAction{chatId='" + this.chatId + '\'' + ", action='" + (Object)((Object)this.action) + '\'' + '}';
    }
}

