/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.send;

import java.io.File;
import java.io.InputStream;
import java.util.Objects;
import org.telegram.telegrambots.api.objects.replykeyboard.ReplyKeyboard;

public class SendDocument {
    public static final String PATH = "senddocument";
    public static final String CHATID_FIELD = "chat_id";
    public static final String DOCUMENT_FIELD = "document";
    public static final String CAPTION_FIELD = "caption";
    public static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    public static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    public static final String REPLYMARKUP_FIELD = "reply_markup";
    private String chatId;
    private String document;
    private String caption;
    private Boolean disableNotification;
    private Integer replyToMessageId;
    private ReplyKeyboard replyMarkup;
    private boolean isNewDocument;
    private String documentName;
    private File newDocumentFile;
    private InputStream newDocumentStream;

    public String getChatId() {
        return this.chatId;
    }

    public SendDocument setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public String getDocument() {
        return this.document;
    }

    public SendDocument setDocument(String document) {
        this.document = document;
        this.isNewDocument = false;
        return this;
    }

    public SendDocument setNewDocument(File file) {
        this.document = file.getName();
        this.isNewDocument = true;
        this.newDocumentFile = file;
        return this;
    }

    public SendDocument setNewDocument(String documentName, InputStream inputStream) {
        Objects.requireNonNull(documentName, "documentName cannot be null!");
        Objects.requireNonNull(inputStream, "inputStream cannot be null!");
        this.documentName = documentName;
        this.isNewDocument = true;
        this.newDocumentStream = inputStream;
        return this;
    }

    public boolean isNewDocument() {
        return this.isNewDocument;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public File getNewDocumentFile() {
        return this.newDocumentFile;
    }

    public InputStream getNewDocumentStream() {
        return this.newDocumentStream;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public SendDocument setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
        return this;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public SendDocument enableNotification() {
        this.disableNotification = false;
        return this;
    }

    public SendDocument disableNotification() {
        this.disableNotification = true;
        return this;
    }

    public String getCaption() {
        return this.caption;
    }

    public SendDocument setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public SendDocument setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public String toString() {
        return "SendDocument{chatId='" + this.chatId + '\'' + ", document='" + this.document + '\'' + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", isNewDocument=" + this.isNewDocument + '}';
    }
}

