/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.send;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class SendLocation
extends BotApiMethod<Message> {
    public static final String PATH = "sendlocation";
    private static final String CHATID_FIELD = "chat_id";
    private static final String LATITUDE_FIELD = "latitude";
    private static final String LONGITUDE_FIELD = "longitude";
    private static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    private static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    private static final String REPLYMARKUP_FIELD = "reply_markup";
    private String chatId;
    private Float latitude;
    private Float longitude;
    private Boolean disableNotification;
    private Integer replyToMessageId;
    private ReplyKeyboard replyMarkup;

    public String getChatId() {
        return this.chatId;
    }

    public SendLocation setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public Float getLatitude() {
        return this.latitude;
    }

    public SendLocation setLatitude(Float latitude) {
        this.latitude = latitude;
        return this;
    }

    public Float getLongitude() {
        return this.longitude;
    }

    public SendLocation setLongitude(Float longitude) {
        this.longitude = longitude;
        return this;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public SendLocation setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
        return this;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public SendLocation setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public SendLocation enableNotification() {
        this.disableNotification = false;
        return this;
    }

    public SendLocation disableNotification() {
        this.disableNotification = true;
        return this;
    }

    @Override
    public String getPath() {
        return PATH;
    }

    @Override
    public Message deserializeResponse(JSONObject answer) {
        if (answer.getBoolean("ok")) {
            return new Message(answer.getJSONObject("result"));
        }
        return null;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.latitude == null) {
            throw new TelegramApiValidationException("Latitude parameter can't be empty", this);
        }
        if (this.longitude == null) {
            throw new TelegramApiValidationException("Longitude parameter can't be empty", this);
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(CHATID_FIELD, this.chatId);
        jsonObject.put(LATITUDE_FIELD, this.latitude);
        jsonObject.put(LONGITUDE_FIELD, this.longitude);
        if (this.disableNotification != null) {
            jsonObject.put(DISABLENOTIFICATION_FIELD, this.disableNotification);
        }
        if (this.replyToMessageId != null) {
            jsonObject.put(REPLYTOMESSAGEID_FIELD, this.replyToMessageId);
        }
        if (this.replyMarkup != null) {
            jsonObject.put(REPLYMARKUP_FIELD, this.replyMarkup.toJson());
        }
        return jsonObject;
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("method", PATH);
        gen.writeStringField(CHATID_FIELD, this.chatId);
        gen.writeNumberField(LATITUDE_FIELD, this.latitude.floatValue());
        gen.writeNumberField(LONGITUDE_FIELD, this.longitude.floatValue());
        if (this.disableNotification != null) {
            gen.writeBooleanField(DISABLENOTIFICATION_FIELD, this.disableNotification);
        }
        if (this.replyToMessageId != null) {
            gen.writeNumberField(REPLYTOMESSAGEID_FIELD, this.replyToMessageId);
        }
        if (this.replyMarkup != null) {
            gen.writeObjectField(REPLYMARKUP_FIELD, this.replyMarkup);
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "SendLocation{chatId='" + this.chatId + '\'' + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + '}';
    }
}

