/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.send;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class SendMessage
extends BotApiMethod<Message> {
    public static final String PATH = "sendmessage";
    private static final String CHATID_FIELD = "chat_id";
    private static final String TEXT_FIELD = "text";
    private static final String PARSEMODE_FIELD = "parse_mode";
    private static final String DISABLEWEBPAGEPREVIEW_FIELD = "disable_web_page_preview";
    private static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    private static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    private static final String REPLYMARKUP_FIELD = "reply_markup";
    private String chatId;
    private String text;
    private String parseMode;
    private Boolean disableWebPagePreview;
    private Boolean disableNotification;
    private Integer replyToMessageId;
    private ReplyKeyboard replyMarkup;

    public String getChatId() {
        return this.chatId;
    }

    public SendMessage setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public SendMessage setText(String text) {
        this.text = text;
        return this;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public SendMessage setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
        return this;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public SendMessage setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public Boolean getDisableWebPagePreview() {
        return this.disableWebPagePreview;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public SendMessage disableWebPagePreview() {
        this.disableWebPagePreview = true;
        return this;
    }

    public SendMessage enableWebPagePreview() {
        this.disableWebPagePreview = null;
        return this;
    }

    public SendMessage enableNotification() {
        this.disableNotification = null;
        return this;
    }

    public SendMessage disableNotification() {
        this.disableNotification = true;
        return this;
    }

    public SendMessage enableMarkdown(boolean enable) {
        this.parseMode = enable ? "Markdown" : null;
        return this;
    }

    public SendMessage enableHtml(boolean enable) {
        this.parseMode = enable ? "html" : null;
        return this;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(CHATID_FIELD, this.chatId);
        jsonObject.put(TEXT_FIELD, this.text);
        if (this.parseMode != null) {
            jsonObject.put(PARSEMODE_FIELD, this.parseMode);
        }
        if (this.disableWebPagePreview != null) {
            jsonObject.put(DISABLEWEBPAGEPREVIEW_FIELD, this.disableWebPagePreview);
        }
        if (this.disableNotification != null) {
            jsonObject.put(DISABLENOTIFICATION_FIELD, this.disableNotification);
        }
        if (this.replyToMessageId != null) {
            jsonObject.put(REPLYTOMESSAGEID_FIELD, this.replyToMessageId);
        }
        if (this.replyMarkup != null) {
            jsonObject.put(REPLYMARKUP_FIELD, this.replyMarkup.toJson());
        }
        return jsonObject;
    }

    @Override
    public String getPath() {
        return PATH;
    }

    @Override
    public Message deserializeResponse(JSONObject answer) {
        if (answer.getBoolean("ok")) {
            return new Message(answer.getJSONObject("result"));
        }
        return null;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.text == null || this.text.isEmpty()) {
            throw new TelegramApiValidationException("Text parameter can't be empty", this);
        }
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("method", PATH);
        gen.writeStringField(CHATID_FIELD, this.chatId);
        gen.writeStringField(TEXT_FIELD, this.text);
        if (this.parseMode != null) {
            gen.writeStringField(PARSEMODE_FIELD, this.parseMode);
        }
        if (this.disableWebPagePreview != null) {
            gen.writeBooleanField(DISABLEWEBPAGEPREVIEW_FIELD, this.disableWebPagePreview);
        }
        if (this.disableNotification != null) {
            gen.writeBooleanField(DISABLENOTIFICATION_FIELD, this.disableNotification);
        }
        if (this.replyToMessageId != null) {
            gen.writeNumberField(REPLYTOMESSAGEID_FIELD, this.replyToMessageId);
        }
        if (this.replyMarkup != null) {
            gen.writeObjectField(REPLYMARKUP_FIELD, this.replyMarkup);
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "SendMessage{chatId='" + this.chatId + '\'' + ", text='" + this.text + '\'' + ", parseMode='" + this.parseMode + '\'' + ", disableWebPagePreview=" + this.disableWebPagePreview + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + '}';
    }
}

