/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.send;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class SendVenue
extends BotApiMethod<Message> {
    public static final String PATH = "sendVenue";
    private static final String CHATID_FIELD = "chat_id";
    private static final String LATITUDE_FIELD = "latitude";
    private static final String LONGITUDE_FIELD = "longitude";
    private static final String TITLE_FIELD = "title";
    private static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    private static final String ADDRESS_FIELD = "address";
    private static final String FOURSQUARE_ID_FIELD = "foursquare_id";
    private static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    private static final String REPLYMARKUP_FIELD = "reply_markup";
    private String chatId;
    private Float latitude;
    private Float longitude;
    private String title;
    private Boolean disableNotification;
    private String address;
    private String foursquareId;
    private Integer replyToMessageId;
    private ReplyKeyboard replyMarkup;

    public String getChatId() {
        return this.chatId;
    }

    public SendVenue setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public Float getLatitude() {
        return this.latitude;
    }

    public SendVenue setLatitude(Float latitude) {
        this.latitude = latitude;
        return this;
    }

    public Float getLongitude() {
        return this.longitude;
    }

    public SendVenue setLongitude(Float longitude) {
        this.longitude = longitude;
        return this;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public SendVenue setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
        return this;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public SendVenue setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public SendVenue enableNotification() {
        this.disableNotification = false;
        return this;
    }

    public SendVenue disableNotification() {
        this.disableNotification = true;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public SendVenue setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public SendVenue setAddress(String address) {
        this.address = address;
        return this;
    }

    public String getFoursquareId() {
        return this.foursquareId;
    }

    public SendVenue setFoursquareId(String foursquareId) {
        this.foursquareId = foursquareId;
        return this;
    }

    @Override
    public String getPath() {
        return PATH;
    }

    @Override
    public Message deserializeResponse(JSONObject answer) {
        if (answer.getBoolean("ok")) {
            return new Message(answer.getJSONObject("result"));
        }
        return null;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.longitude == null) {
            throw new TelegramApiValidationException("Longitude parameter can't be empty", this);
        }
        if (this.latitude == null) {
            throw new TelegramApiValidationException("Latitude parameter can't be empty", this);
        }
        if (this.title == null || this.title.isEmpty()) {
            throw new TelegramApiValidationException("Title parameter can't be empty", this);
        }
        if (this.address == null) {
            throw new TelegramApiValidationException("Address parameter can't be empty", this);
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(CHATID_FIELD, this.chatId);
        jsonObject.put(LATITUDE_FIELD, this.latitude);
        jsonObject.put(LONGITUDE_FIELD, this.longitude);
        jsonObject.put(TITLE_FIELD, this.title);
        jsonObject.put(ADDRESS_FIELD, this.address);
        if (this.foursquareId != null) {
            jsonObject.put(FOURSQUARE_ID_FIELD, this.foursquareId);
        }
        if (this.disableNotification != null) {
            jsonObject.put(DISABLENOTIFICATION_FIELD, this.disableNotification);
        }
        if (this.replyToMessageId != null) {
            jsonObject.put(REPLYTOMESSAGEID_FIELD, this.replyToMessageId);
        }
        if (this.replyMarkup != null) {
            jsonObject.put(REPLYMARKUP_FIELD, this.replyMarkup.toJson());
        }
        return jsonObject;
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("method", PATH);
        gen.writeStringField(CHATID_FIELD, this.chatId);
        gen.writeNumberField(LATITUDE_FIELD, this.latitude.floatValue());
        gen.writeNumberField(LONGITUDE_FIELD, this.longitude.floatValue());
        gen.writeStringField(TITLE_FIELD, this.title);
        gen.writeStringField(ADDRESS_FIELD, this.address);
        if (this.foursquareId != null) {
            gen.writeStringField(FOURSQUARE_ID_FIELD, this.foursquareId);
        }
        if (this.disableNotification != null) {
            gen.writeBooleanField(DISABLENOTIFICATION_FIELD, this.disableNotification);
        }
        if (this.replyToMessageId != null) {
            gen.writeNumberField(REPLYTOMESSAGEID_FIELD, this.replyToMessageId);
        }
        if (this.replyMarkup != null) {
            gen.writeObjectField(REPLYMARKUP_FIELD, this.replyMarkup);
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "SendVenue{chatId='" + this.chatId + '\'' + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", title=" + this.title + ", address=" + this.address + ", foursquareId=" + this.foursquareId + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + '}';
    }
}

