/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.updatingmessages;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class EditMessageReplyMarkup
extends BotApiMethod<Message> {
    public static final String PATH = "editmessagereplymarkup";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MESSAGEID_FIELD = "message_id";
    private static final String INLINE_MESSAGE_ID_FIELD = "inline_message_id";
    private static final String REPLYMARKUP_FIELD = "reply_markup";
    private String chatId;
    private Integer messageId;
    private String inlineMessageId;
    private InlineKeyboardMarkup replyMarkup;

    public String getChatId() {
        return this.chatId;
    }

    public EditMessageReplyMarkup setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public EditMessageReplyMarkup setMessageId(Integer messageId) {
        this.messageId = messageId;
        return this;
    }

    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    public EditMessageReplyMarkup setInlineMessageId(String inlineMessageId) {
        this.inlineMessageId = inlineMessageId;
        return this;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public EditMessageReplyMarkup setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        if (this.inlineMessageId == null) {
            jsonObject.put(CHATID_FIELD, this.chatId);
            jsonObject.put(MESSAGEID_FIELD, this.messageId);
        } else {
            jsonObject.put(INLINE_MESSAGE_ID_FIELD, this.inlineMessageId);
        }
        if (this.replyMarkup != null) {
            jsonObject.put(REPLYMARKUP_FIELD, this.replyMarkup.toJson());
        }
        return jsonObject;
    }

    @Override
    public String getPath() {
        return PATH;
    }

    @Override
    public Message deserializeResponse(JSONObject answer) {
        if (answer.getBoolean("ok")) {
            try {
                return new Message(answer.getJSONObject("result"));
            }
            catch (JSONException e) {
                return new Message();
            }
        }
        return null;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.inlineMessageId == null) {
            if (this.chatId == null) {
                throw new TelegramApiValidationException("ChatId parameter can't be empty if inlineMessageId is not present", this);
            }
            if (this.messageId == null) {
                throw new TelegramApiValidationException("MessageId parameter can't be empty if inlineMessageId is not present", this);
            }
        } else {
            if (this.chatId != null) {
                throw new TelegramApiValidationException("ChatId parameter must be empty if inlineMessageId is provided", this);
            }
            if (this.messageId != null) {
                throw new TelegramApiValidationException("MessageId parameter must be empty if inlineMessageId is provided", this);
            }
        }
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("method", PATH);
        if (this.inlineMessageId == null) {
            gen.writeStringField(CHATID_FIELD, this.chatId);
            gen.writeNumberField(MESSAGEID_FIELD, this.messageId);
        } else {
            gen.writeStringField(INLINE_MESSAGE_ID_FIELD, this.inlineMessageId);
        }
        if (this.replyMarkup != null) {
            gen.writeObjectField(REPLYMARKUP_FIELD, this.replyMarkup);
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "EditMessageReplyMarkup{chatId=" + this.chatId + ", messageId=" + this.messageId + ", inlineMessageId=" + this.inlineMessageId + ", replyMarkup=" + this.replyMarkup + '}';
    }
}

