/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.updatingmessages;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class EditMessageText
extends BotApiMethod<Message> {
    public static final String PATH = "editmessagetext";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MESSAGEID_FIELD = "message_id";
    private static final String INLINE_MESSAGE_ID_FIELD = "inline_message_id";
    private static final String TEXT_FIELD = "text";
    private static final String PARSE_MODE_FIELD = "parse_mode";
    private static final String DISABLE_WEB_PREVIEW_FIELD = "disable_web_page_preview";
    private static final String REPLYMARKUP_FIELD = "reply_markup";
    private String chatId;
    private Integer messageId;
    private String inlineMessageId;
    private String text;
    private String parseMode;
    private Boolean disableWebPagePreview;
    private InlineKeyboardMarkup replyMarkup;

    public String getChatId() {
        return this.chatId;
    }

    public EditMessageText setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public EditMessageText setMessageId(Integer messageId) {
        this.messageId = messageId;
        return this;
    }

    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    public EditMessageText setInlineMessageId(String inlineMessageId) {
        this.inlineMessageId = inlineMessageId;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public EditMessageText setText(String text) {
        this.text = text;
        return this;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public EditMessageText setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public EditMessageText disableWebPagePreview() {
        this.disableWebPagePreview = true;
        return this;
    }

    public EditMessageText enableWebPagePreview() {
        this.disableWebPagePreview = null;
        return this;
    }

    public EditMessageText enableMarkdown(boolean enable) {
        this.parseMode = enable ? "Markdown" : null;
        return this;
    }

    public EditMessageText enableHtml(boolean enable) {
        this.parseMode = enable ? "html" : null;
        return this;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        if (this.inlineMessageId == null) {
            jsonObject.put(CHATID_FIELD, this.chatId);
            jsonObject.put(MESSAGEID_FIELD, this.messageId);
        } else {
            jsonObject.put(INLINE_MESSAGE_ID_FIELD, this.inlineMessageId);
        }
        jsonObject.put(TEXT_FIELD, this.text);
        if (this.parseMode != null) {
            jsonObject.put(PARSE_MODE_FIELD, this.parseMode);
        }
        if (this.disableWebPagePreview != null) {
            jsonObject.put(DISABLE_WEB_PREVIEW_FIELD, this.disableWebPagePreview);
        }
        if (this.replyMarkup != null) {
            jsonObject.put(REPLYMARKUP_FIELD, this.replyMarkup.toJson());
        }
        return jsonObject;
    }

    @Override
    public String getPath() {
        return PATH;
    }

    @Override
    public Message deserializeResponse(JSONObject answer) {
        if (answer.getBoolean("ok")) {
            try {
                return new Message(answer.getJSONObject("result"));
            }
            catch (JSONException e) {
                return new Message();
            }
        }
        return null;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.inlineMessageId == null) {
            if (this.chatId == null) {
                throw new TelegramApiValidationException("ChatId parameter can't be empty if inlineMessageId is not present", this);
            }
            if (this.messageId == null) {
                throw new TelegramApiValidationException("MessageId parameter can't be empty if inlineMessageId is not present", this);
            }
        } else {
            if (this.chatId != null) {
                throw new TelegramApiValidationException("ChatId parameter must be empty if inlineMessageId is provided", this);
            }
            if (this.messageId != null) {
                throw new TelegramApiValidationException("MessageId parameter must be empty if inlineMessageId is provided", this);
            }
        }
        if (this.text == null || this.text.isEmpty()) {
            throw new TelegramApiValidationException("Text parameter can't be empty", this);
        }
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("method", PATH);
        if (this.inlineMessageId == null) {
            gen.writeStringField(CHATID_FIELD, this.chatId);
            gen.writeNumberField(MESSAGEID_FIELD, this.messageId);
        } else {
            gen.writeStringField(INLINE_MESSAGE_ID_FIELD, this.inlineMessageId);
        }
        gen.writeStringField(TEXT_FIELD, this.text);
        if (this.parseMode != null) {
            gen.writeStringField(PARSE_MODE_FIELD, this.parseMode);
        }
        if (this.disableWebPagePreview != null) {
            gen.writeBooleanField(DISABLE_WEB_PREVIEW_FIELD, this.disableWebPagePreview);
        }
        if (this.replyMarkup != null) {
            gen.writeObjectField(REPLYMARKUP_FIELD, this.replyMarkup);
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "EditMessageText{chatId=" + this.chatId + ", messageId=" + this.messageId + ", inlineMessageId=" + this.inlineMessageId + ", text=" + this.text + ", parseMode=" + this.parseMode + ", disableWebPagePreview=" + this.disableWebPagePreview + ", replyMarkup=" + this.replyMarkup + '}';
    }
}

