/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.api.objects.User;

public class CallbackQuery
implements IBotApiObject {
    private static final String ID_FIELD = "id";
    private static final String FROM_FIELD = "from";
    private static final String MESSAGE_FIELD = "message";
    private static final String INLINE_MESSAGE_ID_FIELD = "inline_message_id";
    private static final String DATA_FIELD = "data";
    private static final String GAMESHORTNAME_FIELD = "game_short_name";
    private static final String CHAT_INSTANCE_FIELD = "chat_instance";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="from")
    private User from;
    @JsonProperty(value="message")
    private Message message;
    @JsonProperty(value="inline_message_id")
    private String inlineMessageId;
    @JsonProperty(value="data")
    private String data;
    @JsonProperty(value="game_short_name")
    private String gameShortName;
    @JsonProperty(value="chat_instance")
    private String chatInstance;

    public CallbackQuery() {
    }

    public CallbackQuery(JSONObject jsonObject) {
        this.id = jsonObject.getString(ID_FIELD);
        this.from = new User(jsonObject.getJSONObject(FROM_FIELD));
        this.chatInstance = jsonObject.getString(CHAT_INSTANCE_FIELD);
        if (jsonObject.has(MESSAGE_FIELD)) {
            this.message = new Message(jsonObject.getJSONObject(MESSAGE_FIELD));
        }
        if (jsonObject.has(INLINE_MESSAGE_ID_FIELD)) {
            this.inlineMessageId = jsonObject.getString(INLINE_MESSAGE_ID_FIELD);
        }
        if (jsonObject.has(DATA_FIELD)) {
            this.data = jsonObject.getString(DATA_FIELD);
        }
        if (jsonObject.has(GAMESHORTNAME_FIELD)) {
            this.gameShortName = jsonObject.getString(GAMESHORTNAME_FIELD);
        }
    }

    public String getId() {
        return this.id;
    }

    public User getFrom() {
        return this.from;
    }

    public Message getMessage() {
        return this.message;
    }

    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    public String getData() {
        return this.data;
    }

    public String getGameShortName() {
        return this.gameShortName;
    }

    public String getChatInstance() {
        return this.chatInstance;
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(ID_FIELD, this.id);
        gen.writeObjectField(FROM_FIELD, this.from);
        gen.writeStringField(CHAT_INSTANCE_FIELD, this.chatInstance);
        if (this.message != null) {
            gen.writeObjectField(MESSAGE_FIELD, this.message);
        }
        if (this.inlineMessageId != null) {
            gen.writeStringField(INLINE_MESSAGE_ID_FIELD, this.inlineMessageId);
        }
        if (this.data != null) {
            gen.writeStringField(DATA_FIELD, this.data);
        }
        if (this.gameShortName != null) {
            gen.writeStringField(GAMESHORTNAME_FIELD, this.gameShortName);
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "CallbackQuery{id='" + this.id + '\'' + ", from=" + this.from + ", message=" + this.message + ", inlineMessageId='" + this.inlineMessageId + '\'' + ", data='" + this.data + '\'' + ", gameShortName='" + this.gameShortName + '\'' + ", chatInstance='" + this.chatInstance + '\'' + '}';
    }
}

