/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;

public class File
implements IBotApiObject {
    public static final String FILEBASEURL = "https://api.telegram.org/file/bot{0}/{1}";
    private static final String FILE_ID = "file_id";
    private static final String FILE_SIZE_FIELD = "file_size";
    private static final String FILE_PATH_FIELD = "file_path";
    @JsonProperty(value="file_id")
    private String fileId;
    @JsonProperty(value="file_size")
    private Integer fileSize;
    @JsonProperty(value="file_path")
    private String filePath;

    public File() {
    }

    public File(JSONObject jsonObject) {
        this.fileId = jsonObject.getString(FILE_ID);
        if (jsonObject.has(FILE_SIZE_FIELD)) {
            this.fileSize = jsonObject.getInt(FILE_SIZE_FIELD);
        }
        if (jsonObject.has(FILE_PATH_FIELD)) {
            this.filePath = jsonObject.getString(FILE_PATH_FIELD);
        }
    }

    public String getFileId() {
        return this.fileId;
    }

    public Integer getFileSize() {
        return this.fileSize;
    }

    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FILE_ID, this.fileId);
        if (this.fileSize != null) {
            gen.writeNumberField(FILE_SIZE_FIELD, this.fileSize);
        }
        if (this.filePath != null) {
            gen.writeStringField(FILE_PATH_FIELD, this.filePath);
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "File{fileId='" + this.fileId + '\'' + ", fileSize=" + this.fileSize + ", filePath='" + this.filePath + '\'' + '}';
    }
}

