/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;
import org.telegram.telegrambots.api.objects.User;

public class MessageEntity
implements IBotApiObject {
    private static final String TYPE_FIELD = "type";
    private static final String OFFSET_FIELD = "offset";
    private static final String LENGTH_FIELD = "length";
    private static final String URL_FIELD = "url";
    private static final String USER_FIELD = "user";
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="offset")
    private Integer offset;
    @JsonProperty(value="length")
    private Integer length;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="user")
    private User user;
    private String text;

    public MessageEntity() {
    }

    public MessageEntity(JSONObject jsonObject) {
        this.type = jsonObject.getString(TYPE_FIELD);
        this.offset = jsonObject.getInt(OFFSET_FIELD);
        this.length = jsonObject.getInt(LENGTH_FIELD);
        if ("text_link".equals(this.type)) {
            this.url = jsonObject.getString(URL_FIELD);
        }
        if ("text_mention".equals(this.type)) {
            this.user = new User(jsonObject.getJSONObject(USER_FIELD));
        }
    }

    public String getType() {
        return this.type;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getLength() {
        return this.length;
    }

    public String getUrl() {
        return this.url;
    }

    public String getText() {
        return this.text;
    }

    public User getUser() {
        return this.user;
    }

    protected void computeText(String message) {
        this.text = message.substring(this.offset, this.offset + this.length);
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(TYPE_FIELD, this.type);
        gen.writeNumberField(OFFSET_FIELD, this.offset);
        gen.writeNumberField(LENGTH_FIELD, this.length);
        if (this.url != null && "text_link".equals(this.type)) {
            gen.writeStringField(URL_FIELD, this.url);
        }
        if (this.user != null && "text_mention".equals(this.type)) {
            gen.writeObjectField(USER_FIELD, this.user);
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "MessageEntity{type='" + this.type + '\'' + ", offset=" + this.offset + ", length=" + this.length + ", url=" + this.url + ", user=" + this.user + '}';
    }
}

