/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;

public class PhotoSize
implements IBotApiObject {
    private static final String FILEID_FIELD = "file_id";
    private static final String WIDTH_FIELD = "width";
    private static final String HEIGHT_FIELD = "height";
    private static final String FILESIZE_FIELD = "file_size";
    private static final String FILEPATH_FIELD = "file_path";
    @JsonProperty(value="file_id")
    private String fileId;
    @JsonProperty(value="width")
    private Integer width;
    @JsonProperty(value="height")
    private Integer height;
    @JsonProperty(value="file_size")
    private Integer fileSize;
    @JsonProperty(value="file_path")
    private String filePath;

    public PhotoSize() {
    }

    public PhotoSize(JSONObject jsonObject) {
        this.fileId = jsonObject.getString(FILEID_FIELD);
        this.width = jsonObject.getInt(WIDTH_FIELD);
        this.height = jsonObject.getInt(HEIGHT_FIELD);
        if (jsonObject.has(FILESIZE_FIELD)) {
            this.fileSize = jsonObject.getInt(FILESIZE_FIELD);
        }
        if (jsonObject.has(FILEPATH_FIELD)) {
            this.filePath = jsonObject.getString(FILEPATH_FIELD);
        }
    }

    public String getFileId() {
        return this.fileId;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Integer getFileSize() {
        return this.fileSize;
    }

    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FILEID_FIELD, this.fileId);
        gen.writeNumberField(WIDTH_FIELD, this.width);
        gen.writeNumberField(HEIGHT_FIELD, this.height);
        if (this.fileSize != null) {
            gen.writeNumberField(FILESIZE_FIELD, this.fileSize);
        }
        if (this.filePath != null) {
            gen.writeStringField(FILEPATH_FIELD, this.filePath);
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "PhotoSize{fileId='" + this.fileId + '\'' + ", width=" + this.width + ", height=" + this.height + ", fileSize=" + this.fileSize + '}';
    }
}

