/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;
import org.telegram.telegrambots.api.objects.PhotoSize;

public class Sticker
implements IBotApiObject {
    private static final String FILEID_FIELD = "file_id";
    private static final String WIDTH_FIELD = "width";
    private static final String HEIGHT_FIELD = "height";
    private static final String THUMB_FIELD = "thumb";
    private static final String FILESIZE_FIELD = "file_size";
    private static final String EMOJI_FIELD = "emoji";
    @JsonProperty(value="file_id")
    private String fileId;
    @JsonProperty(value="width")
    private Integer width;
    @JsonProperty(value="height")
    private Integer height;
    @JsonProperty(value="thumb")
    private PhotoSize thumb;
    @JsonProperty(value="file_size")
    private Integer fileSize;
    @JsonProperty(value="emoji")
    private String emoji;

    public Sticker() {
    }

    public Sticker(JSONObject jsonObject) {
        this.fileId = jsonObject.getString(FILEID_FIELD);
        this.width = jsonObject.getInt(WIDTH_FIELD);
        this.height = jsonObject.getInt(HEIGHT_FIELD);
        if (jsonObject.has(THUMB_FIELD)) {
            this.thumb = new PhotoSize(jsonObject.getJSONObject(THUMB_FIELD));
        }
        if (jsonObject.has(FILESIZE_FIELD)) {
            this.fileSize = jsonObject.getInt(FILESIZE_FIELD);
        }
        if (jsonObject.has(EMOJI_FIELD)) {
            this.emoji = jsonObject.getString(EMOJI_FIELD);
        }
    }

    public String getFileId() {
        return this.fileId;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public PhotoSize getThumb() {
        return this.thumb;
    }

    public Integer getFileSize() {
        return this.fileSize;
    }

    public String getEmoji() {
        return this.emoji;
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FILEID_FIELD, this.fileId);
        gen.writeNumberField(WIDTH_FIELD, this.width);
        gen.writeNumberField(HEIGHT_FIELD, this.height);
        if (this.thumb != null) {
            gen.writeObjectField(THUMB_FIELD, this.thumb);
        }
        if (this.fileSize != null) {
            gen.writeNumberField(FILESIZE_FIELD, this.fileSize);
        }
        if (this.emoji != null) {
            gen.writeStringField(EMOJI_FIELD, this.emoji);
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "Sticker{fileId='" + this.fileId + '\'' + ", width=" + this.width + ", height=" + this.height + ", thumb=" + this.thumb + ", fileSize=" + this.fileSize + ", emoji=" + this.emoji + '}';
    }
}

