/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;
import org.telegram.telegrambots.api.objects.PhotoSize;

public class UserProfilePhotos
implements IBotApiObject {
    private static final String TOTALCOUNT_FIELD = "total_count";
    private static final String PHOTOS_FIELD = "photos";
    @JsonProperty(value="total_count")
    private Integer totalCount;
    @JsonProperty(value="photos")
    private List<List<PhotoSize>> photos;

    public UserProfilePhotos() {
    }

    public UserProfilePhotos(JSONObject jsonObject) {
        this.totalCount = jsonObject.getInt(TOTALCOUNT_FIELD);
        if (this.totalCount > 0) {
            this.photos = new ArrayList<List<PhotoSize>>();
            JSONArray photos = jsonObject.getJSONArray(PHOTOS_FIELD);
            for (int i = 0; i < photos.length(); ++i) {
                JSONArray innerArray = photos.getJSONArray(i);
                ArrayList<PhotoSize> innerPhotos = new ArrayList<PhotoSize>();
                for (int j = 0; j < innerArray.length(); ++j) {
                    innerPhotos.add(new PhotoSize(innerArray.getJSONObject(j)));
                }
                this.photos.add(innerPhotos);
            }
        }
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public List<List<PhotoSize>> getPhotos() {
        return this.photos;
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeNumberField(TOTALCOUNT_FIELD, this.totalCount);
        if (this.totalCount > 0) {
            gen.writeArrayFieldStart(PHOTOS_FIELD);
            for (List<PhotoSize> photoSizeList : this.photos) {
                gen.writeStartArray();
                for (PhotoSize photoSize : photoSizeList) {
                    gen.writeObject(photoSize);
                }
                gen.writeEndArray();
            }
            gen.writeEndArray();
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "UserProfilePhotos{totalCount=" + this.totalCount + ", photos=" + this.photos + '}';
    }
}

