/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;
import org.telegram.telegrambots.api.objects.Location;

public class Venue
implements IBotApiObject {
    private static final String LOCATION_FIELD = "location";
    private static final String TITLE_FIELD = "title";
    private static final String ADDRESS_FIELD = "address";
    private static final String FOURSQUARE_ID_FIELD = "foursquare_id";
    @JsonProperty(value="location")
    private Location location;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="address")
    private String address;
    @JsonProperty(value="foursquare_id")
    private String foursquareId;

    public Venue() {
    }

    public Venue(JSONObject jsonObject) {
        this.location = new Location(jsonObject.getJSONObject(LOCATION_FIELD));
        this.title = jsonObject.getString(TITLE_FIELD);
        this.address = jsonObject.getString(ADDRESS_FIELD);
        if (jsonObject.has(FOURSQUARE_ID_FIELD)) {
            this.foursquareId = jsonObject.getString(FOURSQUARE_ID_FIELD);
        }
    }

    public Location getLocation() {
        return this.location;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAddress() {
        return this.address;
    }

    public String getFoursquareId() {
        return this.foursquareId;
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeObjectField(LOCATION_FIELD, this.location);
        gen.writeStringField(TITLE_FIELD, this.title);
        gen.writeStringField(ADDRESS_FIELD, this.address);
        if (this.foursquareId != null) {
            gen.writeStringField(FOURSQUARE_ID_FIELD, this.foursquareId);
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "Venue{location=" + this.location + ", title=" + this.title + ", address=" + this.address + ", foursquareId=" + this.foursquareId + '}';
    }
}

