/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;

public class Voice
implements IBotApiObject {
    private static final String FILEID_FIELD = "file_id";
    private static final String DURATION_FIELD = "duration";
    private static final String MIMETYPE_FIELD = "mime_type";
    private static final String FILESIZE_FIELD = "file_size";
    @JsonProperty(value="file_id")
    private String fileId;
    @JsonProperty(value="duration")
    private Integer duration;
    @JsonProperty(value="mime_type")
    private String mimeType;
    @JsonProperty(value="file_size")
    private Integer fileSize;

    public Voice() {
    }

    public Voice(JSONObject jsonObject) {
        this.fileId = jsonObject.getString(FILEID_FIELD);
        this.duration = jsonObject.getInt(DURATION_FIELD);
        if (jsonObject.has(MIMETYPE_FIELD)) {
            this.mimeType = jsonObject.getString(MIMETYPE_FIELD);
        }
        if (jsonObject.has(FILESIZE_FIELD)) {
            this.fileSize = jsonObject.getInt(FILESIZE_FIELD);
        }
    }

    public String getFileId() {
        return this.fileId;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Integer getFileSize() {
        return this.fileSize;
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FILEID_FIELD, this.fileId);
        gen.writeNumberField(DURATION_FIELD, this.duration);
        if (this.mimeType != null) {
            gen.writeStringField(MIMETYPE_FIELD, this.mimeType);
        }
        if (this.fileSize != null) {
            gen.writeNumberField(FILESIZE_FIELD, this.fileSize);
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "Voice{fileId='" + this.fileId + '\'' + ", duration=" + this.duration + ", mimeType='" + this.mimeType + '\'' + ", fileSize=" + this.fileSize + '}';
    }
}

