/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects.games;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;
import org.telegram.telegrambots.api.objects.MessageEntity;
import org.telegram.telegrambots.api.objects.PhotoSize;
import org.telegram.telegrambots.api.objects.games.Animation;

public class Game
implements IBotApiObject {
    private static final String TITLE_FIELD = "title";
    private static final String DESCRIPTION_FIELD = "description";
    private static final String PHOTO_FIELD = "photo";
    private static final String ANIMATION_FIELD = "animation";
    private static final String TEXT_FIELD = "text";
    private static final String TEXTENTITIES_FIELD = "text_entities";
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="photo")
    private List<PhotoSize> photo;
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="text_entities")
    private List<MessageEntity> entities;
    @JsonProperty(value="animation")
    private Animation animation;

    public Game() {
    }

    public Game(JSONObject object) {
        this.title = object.getString(TITLE_FIELD);
        this.description = object.getString(DESCRIPTION_FIELD);
        this.photo = new ArrayList<PhotoSize>();
        JSONArray photos = object.getJSONArray(PHOTO_FIELD);
        for (int i = 0; i < photos.length(); ++i) {
            this.photo.add(new PhotoSize(photos.getJSONObject(i)));
        }
        if (object.has(TEXT_FIELD)) {
            this.text = object.getString(TEXT_FIELD);
        }
        if (object.has(TEXTENTITIES_FIELD)) {
            this.entities = new ArrayList<MessageEntity>();
            JSONArray entities = object.getJSONArray(TEXTENTITIES_FIELD);
            for (int i = 0; i < entities.length(); ++i) {
                this.entities.add(new MessageEntity(entities.getJSONObject(i)));
            }
        }
        if (object.has(ANIMATION_FIELD)) {
            this.animation = new Animation(object.getJSONObject(ANIMATION_FIELD));
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PhotoSize> getPhoto() {
        return this.photo;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public String getText() {
        return this.text;
    }

    public boolean hasEntities() {
        return this.entities != null && !this.entities.isEmpty();
    }

    public List<MessageEntity> getEntities() {
        return this.entities;
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(TITLE_FIELD, this.title);
        gen.writeStringField(DESCRIPTION_FIELD, this.description);
        gen.writeArrayFieldStart(PHOTO_FIELD);
        for (PhotoSize photoSize : this.photo) {
            gen.writeObject(photoSize);
        }
        gen.writeEndArray();
        if (this.animation != null) {
            gen.writeObjectField(ANIMATION_FIELD, this.animation);
        }
        if (this.text != null) {
            gen.writeStringField(TEXT_FIELD, this.text);
        }
        if (this.entities != null) {
            gen.writeArrayFieldStart(TEXTENTITIES_FIELD);
            for (MessageEntity entity : this.entities) {
                gen.writeObject(entity);
            }
            gen.writeEndArray();
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "Game{title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", photo=" + this.photo + ", animation=" + this.animation + '}';
    }
}

