/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects.games;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;
import org.telegram.telegrambots.api.objects.User;

public class GameHighScore
implements IBotApiObject {
    private static final String POSITION_FIELD = "position";
    private static final String USER_FIELD = "user";
    private static final String SCORE_FIELD = "score";
    @JsonProperty(value="position")
    private Integer position;
    @JsonProperty(value="user")
    private User user;
    @JsonProperty(value="score")
    private Integer score;

    public GameHighScore(JSONObject object) {
        this.position = object.getInt(POSITION_FIELD);
        this.user = new User(object.getJSONObject(USER_FIELD));
        this.score = object.getInt(SCORE_FIELD);
    }

    public Integer getPosition() {
        return this.position;
    }

    public User getUser() {
        return this.user;
    }

    public Integer getScore() {
        return this.score;
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeNumberField(POSITION_FIELD, this.position);
        gen.writeObjectField(USER_FIELD, this.user);
        gen.writeNumberField(SCORE_FIELD, this.score);
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "GameHighScore{position=" + this.position + ", user=" + this.user + ", score=" + this.score + '}';
    }
}

