/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects.inlinequery;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;
import org.telegram.telegrambots.api.objects.Location;
import org.telegram.telegrambots.api.objects.User;

public class ChosenInlineQuery
implements IBotApiObject {
    private static final String RESULTID_FIELD = "result_id";
    private static final String FROM_FIELD = "from";
    private static final String LOCATION_FIELD = "location";
    private static final String INLINE_MESSAGE_ID_FIELD = "inline_message_id";
    private static final String QUERY_FIELD = "query";
    @JsonProperty(value="result_id")
    private String resultId;
    @JsonProperty(value="from")
    private User from;
    @JsonProperty(value="location")
    private Location location;
    @JsonProperty(value="inline_message_id")
    private String inlineMessageId;
    @JsonProperty(value="query")
    private String query;

    public ChosenInlineQuery() {
    }

    public ChosenInlineQuery(JSONObject jsonObject) {
        this.resultId = jsonObject.getString(RESULTID_FIELD);
        this.from = new User(jsonObject.getJSONObject(FROM_FIELD));
        if (jsonObject.has(LOCATION_FIELD)) {
            this.location = new Location(jsonObject.getJSONObject(LOCATION_FIELD));
        }
        if (jsonObject.has(INLINE_MESSAGE_ID_FIELD)) {
            this.inlineMessageId = jsonObject.getString(INLINE_MESSAGE_ID_FIELD);
        }
        this.query = jsonObject.getString(QUERY_FIELD);
    }

    public String getResultId() {
        return this.resultId;
    }

    public User getFrom() {
        return this.from;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    public String getQuery() {
        return this.query;
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(RESULTID_FIELD, this.resultId);
        gen.writeObjectField(FROM_FIELD, this.from);
        if (this.location != null) {
            gen.writeObjectField(LOCATION_FIELD, this.location);
        }
        if (this.inlineMessageId != null) {
            gen.writeStringField(INLINE_MESSAGE_ID_FIELD, this.inlineMessageId);
        }
        gen.writeStringField(QUERY_FIELD, this.query);
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "ChosenInlineQuery{resultId='" + this.resultId + '\'' + ", from=" + this.from + ", location=" + this.location + ", inlineMessageId=" + this.inlineMessageId + ", query='" + this.query + '\'' + '}';
    }
}

