/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects.inlinequery;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;
import org.telegram.telegrambots.api.objects.Location;
import org.telegram.telegrambots.api.objects.User;

public class InlineQuery
implements IBotApiObject {
    private static final String ID_FIELD = "id";
    private static final String FROM_FIELD = "from";
    private static final String LOCATION_FIELD = "location";
    private static final String QUERY_FIELD = "query";
    private static final String OFFSET_FIELD = "offset";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="from")
    private User from;
    @JsonProperty(value="location")
    private Location location;
    @JsonProperty(value="query")
    private String query;
    @JsonProperty(value="offset")
    private String offset;

    public InlineQuery() {
    }

    public InlineQuery(JSONObject jsonObject) {
        this.id = jsonObject.getString(ID_FIELD);
        this.from = new User(jsonObject.getJSONObject(FROM_FIELD));
        if (jsonObject.has(LOCATION_FIELD)) {
            this.location = new Location(jsonObject.getJSONObject(LOCATION_FIELD));
        }
        this.query = jsonObject.getString(QUERY_FIELD);
        this.offset = jsonObject.getString(OFFSET_FIELD);
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(ID_FIELD, this.id);
        gen.writeObjectField(FROM_FIELD, this.from);
        if (this.location != null) {
            gen.writeObjectField(LOCATION_FIELD, this.location);
        }
        gen.writeStringField(QUERY_FIELD, this.query);
        gen.writeStringField(OFFSET_FIELD, this.offset);
        gen.writeEndObject();
        gen.flush();
    }

    public String getId() {
        return this.id;
    }

    public User getFrom() {
        return this.from;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getQuery() {
        return this.query;
    }

    public String getOffset() {
        return this.offset;
    }

    public boolean hasQuery() {
        return this.query != null && !this.query.isEmpty();
    }

    public boolean hasLocation() {
        return this.location != null;
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "InlineQuery{id='" + this.id + '\'' + ", from=" + this.from + ", location=" + this.location + ", query='" + this.query + '\'' + ", offset='" + this.offset + '\'' + '}';
    }
}

