/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects.replykeyboard;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.telegram.telegrambots.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.api.objects.replykeyboard.buttons.InlineKeyboardButton;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class InlineKeyboardMarkup
implements ReplyKeyboard {
    private static final String KEYBOARD_FIELD = "inline_keyboard";
    @JsonProperty(value="inline_keyboard")
    private List<List<InlineKeyboardButton>> keyboard = new ArrayList<List<InlineKeyboardButton>>();

    public List<List<InlineKeyboardButton>> getKeyboard() {
        return this.keyboard;
    }

    public InlineKeyboardMarkup setKeyboard(List<List<InlineKeyboardButton>> keyboard) {
        this.keyboard = keyboard;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.keyboard == null) {
            throw new TelegramApiValidationException("Keyboard parameter can't be null", this);
        }
        for (List<InlineKeyboardButton> inlineKeyboardButtons : this.keyboard) {
            for (InlineKeyboardButton inlineKeyboardButton : inlineKeyboardButtons) {
                inlineKeyboardButton.validate();
            }
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonkeyboard = new JSONArray();
        for (List<InlineKeyboardButton> innerRow : this.keyboard) {
            JSONArray innerJSONKeyboard = new JSONArray();
            for (InlineKeyboardButton element : innerRow) {
                innerJSONKeyboard.put(element.toJson());
            }
            jsonkeyboard.put(innerJSONKeyboard);
        }
        jsonObject.put(KEYBOARD_FIELD, jsonkeyboard);
        return jsonObject;
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeArrayFieldStart(KEYBOARD_FIELD);
        for (List<InlineKeyboardButton> innerRow : this.keyboard) {
            gen.writeStartArray();
            for (InlineKeyboardButton element : innerRow) {
                gen.writeObject(element);
            }
            gen.writeEndArray();
        }
        gen.writeEndArray();
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "InlineKeyboardMarkup{inline_keyboard=" + this.keyboard + '}';
    }
}

