/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects.replykeyboard.buttons;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;
import org.telegram.telegrambots.api.interfaces.IToJson;
import org.telegram.telegrambots.api.interfaces.Validable;
import org.telegram.telegrambots.api.objects.games.CallbackGame;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class InlineKeyboardButton
implements IBotApiObject,
IToJson,
Validable {
    private static final String TEXT_FIELD = "text";
    private static final String URL_FIELD = "url";
    private static final String CALLBACK_DATA_FIELD = "callback_data";
    private static final String CALLBACK_GAME_FIELD = "callback_game";
    private static final String SWITCH_INLINE_QUERY_FIELD = "switch_inline_query";
    private static final String SWITCH_INLINE_QUERY_CURRENT_CHAT_FIELD = "switch_inline_query_current_chat";
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="callback_data")
    private String callbackData;
    @JsonProperty(value="callback_game")
    private CallbackGame callbackGame;
    @JsonProperty(value="switch_inline_query")
    private String switchInlineQuery;
    @JsonProperty(value="switch_inline_query_current_chat")
    private String switchInlineQueryCurrentChat;

    public InlineKeyboardButton() {
    }

    public InlineKeyboardButton(JSONObject jsonObject) {
        this.text = jsonObject.getString(TEXT_FIELD);
        if (jsonObject.has(URL_FIELD)) {
            this.url = jsonObject.getString(URL_FIELD);
        }
        if (jsonObject.has(CALLBACK_DATA_FIELD)) {
            this.callbackData = jsonObject.getString(CALLBACK_DATA_FIELD);
        }
        if (jsonObject.has(CALLBACK_GAME_FIELD)) {
            this.callbackGame = new CallbackGame(jsonObject.getJSONObject(CALLBACK_GAME_FIELD));
        }
        if (jsonObject.has(SWITCH_INLINE_QUERY_FIELD)) {
            this.switchInlineQuery = jsonObject.getString(SWITCH_INLINE_QUERY_FIELD);
        }
        if (jsonObject.has(SWITCH_INLINE_QUERY_CURRENT_CHAT_FIELD)) {
            this.switchInlineQueryCurrentChat = jsonObject.getString(SWITCH_INLINE_QUERY_CURRENT_CHAT_FIELD);
        }
    }

    public String getText() {
        return this.text;
    }

    public InlineKeyboardButton setText(String text) {
        this.text = text;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public InlineKeyboardButton setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getCallbackData() {
        return this.callbackData;
    }

    public InlineKeyboardButton setCallbackData(String callbackData) {
        this.callbackData = callbackData;
        return this;
    }

    public String getSwitchInlineQuery() {
        return this.switchInlineQuery;
    }

    public InlineKeyboardButton setSwitchInlineQuery(String switchInlineQuery) {
        this.switchInlineQuery = switchInlineQuery;
        return this;
    }

    public CallbackGame getCallbackGame() {
        return this.callbackGame;
    }

    public InlineKeyboardButton setCallbackGame(CallbackGame callbackGame) {
        this.callbackGame = callbackGame;
        return this;
    }

    public String getSwitchInlineQueryCurrentChat() {
        return this.switchInlineQueryCurrentChat;
    }

    public InlineKeyboardButton setSwitchInlineQueryCurrentChat(String switchInlineQueryCurrentChat) {
        this.switchInlineQueryCurrentChat = switchInlineQueryCurrentChat;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.text == null || this.text.isEmpty()) {
            throw new TelegramApiValidationException("Text parameter can't be empty", this);
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(TEXT_FIELD, this.text);
        if (this.url != null) {
            jsonObject.put(URL_FIELD, this.url);
        }
        if (this.callbackData != null) {
            jsonObject.put(CALLBACK_DATA_FIELD, this.callbackData);
        }
        if (this.switchInlineQuery != null) {
            jsonObject.put(SWITCH_INLINE_QUERY_FIELD, this.switchInlineQuery);
        }
        if (this.switchInlineQueryCurrentChat != null) {
            jsonObject.put(SWITCH_INLINE_QUERY_CURRENT_CHAT_FIELD, this.switchInlineQueryCurrentChat);
        }
        if (this.callbackGame != null) {
            jsonObject.put(CALLBACK_GAME_FIELD, this.callbackGame);
        }
        return jsonObject;
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(TEXT_FIELD, this.text);
        if (this.url != null) {
            gen.writeStringField(URL_FIELD, this.url);
        }
        if (this.callbackData != null) {
            gen.writeStringField(CALLBACK_DATA_FIELD, this.callbackData);
        }
        if (this.switchInlineQuery != null) {
            gen.writeStringField(SWITCH_INLINE_QUERY_FIELD, this.switchInlineQuery);
        }
        if (this.switchInlineQueryCurrentChat != null) {
            gen.writeStringField(SWITCH_INLINE_QUERY_CURRENT_CHAT_FIELD, this.switchInlineQueryCurrentChat);
        }
        if (this.callbackGame != null) {
            gen.writeObjectField(CALLBACK_GAME_FIELD, this.callbackGame);
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "InlineKeyboardButton{text='" + this.text + '\'' + ", url='" + this.url + '\'' + ", callbackData='" + this.callbackData + '\'' + ", callbackGame=" + this.callbackGame + ", switchInlineQuery='" + this.switchInlineQuery + '\'' + ", switchInlineQueryCurrentChat='" + this.switchInlineQueryCurrentChat + '\'' + '}';
    }
}

