/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects.replykeyboard.buttons;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;
import org.telegram.telegrambots.api.interfaces.IToJson;
import org.telegram.telegrambots.api.interfaces.Validable;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class KeyboardButton
implements IBotApiObject,
IToJson,
Validable {
    private static final String TEXT_FIELD = "text";
    private static final String REQUEST_CONTACT_FIELD = "request_contact";
    private static final String REQUEST_LOCATION_FIELD = "request_location";
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="request_contact")
    private Boolean requestContact;
    @JsonProperty(value="request_location")
    private Boolean requestLocation;

    public KeyboardButton() {
    }

    public KeyboardButton(String text) {
        this.text = text;
    }

    public KeyboardButton(JSONObject jsonObject) {
        this.text = jsonObject.getString(TEXT_FIELD);
        if (jsonObject.has(REQUEST_CONTACT_FIELD)) {
            this.requestContact = jsonObject.getBoolean(REQUEST_CONTACT_FIELD);
        }
        if (jsonObject.has(REQUEST_LOCATION_FIELD)) {
            this.requestLocation = jsonObject.getBoolean(REQUEST_LOCATION_FIELD);
        }
    }

    public String getText() {
        return this.text;
    }

    public KeyboardButton setText(String text) {
        this.text = text;
        return this;
    }

    public Boolean getRequestContact() {
        return this.requestContact;
    }

    public KeyboardButton setRequestContact(Boolean requestContact) {
        this.requestContact = requestContact;
        return this;
    }

    public Boolean getRequestLocation() {
        return this.requestLocation;
    }

    public KeyboardButton setRequestLocation(Boolean requestLocation) {
        this.requestLocation = requestLocation;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.text == null || this.text.isEmpty()) {
            throw new TelegramApiValidationException("Text parameter can't be empty", this);
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(TEXT_FIELD, this.text);
        if (this.requestContact != null) {
            jsonObject.put(REQUEST_CONTACT_FIELD, this.requestContact);
        }
        if (this.requestLocation != null) {
            jsonObject.put(REQUEST_LOCATION_FIELD, this.requestLocation);
        }
        return jsonObject;
    }

    @Override
    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(TEXT_FIELD, this.text);
        if (this.requestContact != null) {
            gen.writeBooleanField(REQUEST_CONTACT_FIELD, this.requestContact);
        }
        if (this.requestLocation != null) {
            gen.writeBooleanField(REQUEST_LOCATION_FIELD, this.requestLocation);
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "KeyboardButton{text=" + this.text + ", requestContact=" + this.requestContact + ", requestLocation=" + this.requestLocation + '}';
    }
}

