/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.exceptions;

import org.json.JSONObject;
import org.telegram.telegrambots.api.objects.ResponseParameters;
import org.telegram.telegrambots.exceptions.TelegramApiException;

public class TelegramApiRequestException
extends TelegramApiException {
    private static final String ERRORDESCRIPTIONFIELD = "description";
    private static final String ERRORCODEFIELD = "error_code";
    private static final String PARAMETERSFIELD = "parameters";
    private String apiResponse = null;
    private Integer errorCode = 0;
    private ResponseParameters parameters;

    public TelegramApiRequestException(String message) {
        super(message);
    }

    public TelegramApiRequestException(String message, JSONObject object) {
        super(message);
        this.apiResponse = object.getString(ERRORDESCRIPTIONFIELD);
        this.errorCode = object.getInt(ERRORCODEFIELD);
        if (object.has(PARAMETERSFIELD)) {
            this.parameters = new ResponseParameters(object.getJSONObject(PARAMETERSFIELD));
        }
    }

    public TelegramApiRequestException(String message, Throwable cause) {
        super(message, cause);
    }

    public String getApiResponse() {
        return this.apiResponse;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public ResponseParameters getParameters() {
        return this.parameters;
    }

    @Override
    public String toString() {
        if (this.apiResponse == null) {
            return super.toString();
        }
        if (this.errorCode == null) {
            return super.toString() + ": " + this.apiResponse;
        }
        return super.toString() + ": [" + this.errorCode + "] " + this.apiResponse;
    }
}

