/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.updatesreceivers;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.methods.updates.GetUpdates;
import org.telegram.telegrambots.api.objects.Update;
import org.telegram.telegrambots.bots.BotOptions;
import org.telegram.telegrambots.bots.ITelegramLongPollingBot;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.logging.BotLogger;

public class BotSession {
    private static final String LOGTAG = "BOTSESSION";
    private static final int SOCKET_TIMEOUT = 75000;
    private final ITelegramLongPollingBot callback;
    private final ReaderThread readerThread;
    private final HandlerThread handlerThread;
    private final ConcurrentLinkedDeque<Update> receivedUpdates = new ConcurrentLinkedDeque();
    private final String token;
    private int lastReceivedUpdate = 0;
    private volatile boolean running = true;
    private volatile CloseableHttpClient httpclient;
    private volatile RequestConfig requestConfig;

    public BotSession(String token, ITelegramLongPollingBot callback, BotOptions options) {
        this.token = token;
        this.callback = callback;
        this.httpclient = HttpClientBuilder.create().setSSLHostnameVerifier(new NoopHostnameVerifier()).setConnectionTimeToLive(70L, TimeUnit.SECONDS).setMaxConnTotal(100).build();
        RequestConfig.Builder configBuilder = RequestConfig.copy(RequestConfig.custom().build());
        if (options.hasProxy()) {
            configBuilder.setProxy(new HttpHost(options.getProxyHost(), options.getProxyPort()));
        }
        this.requestConfig = configBuilder.setSocketTimeout(75000).setConnectTimeout(75000).setConnectionRequestTimeout(75000).build();
        this.readerThread = new ReaderThread();
        this.readerThread.setName(callback.getBotUsername() + " Telegram Connection");
        this.readerThread.start();
        this.handlerThread = new HandlerThread();
        this.handlerThread.setName(callback.getBotUsername() + " Telegram Executor");
        this.handlerThread.start();
    }

    public void close() {
        this.running = false;
        if (this.readerThread != null) {
            this.readerThread.interrupt();
        }
        if (this.handlerThread != null) {
            this.handlerThread.interrupt();
        }
        if (this.httpclient != null) {
            try {
                this.httpclient.close();
                this.httpclient = null;
            }
            catch (IOException e) {
                BotLogger.severe(LOGTAG, e);
            }
        }
        if (this.callback != null) {
            this.callback.onClosing();
        }
    }

    private class HandlerThread
    extends Thread {
        private HandlerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setPriority(1);
            while (BotSession.this.running) {
                try {
                    Update update = (Update)BotSession.this.receivedUpdates.pollLast();
                    if (update == null) {
                        ConcurrentLinkedDeque concurrentLinkedDeque = BotSession.this.receivedUpdates;
                        synchronized (concurrentLinkedDeque) {
                            BotSession.this.receivedUpdates.wait();
                            update = (Update)BotSession.this.receivedUpdates.pollLast();
                            if (update == null) {
                                continue;
                            }
                        }
                    }
                    BotSession.this.callback.onUpdateReceived(update);
                }
                catch (InterruptedException e) {
                    BotLogger.debug(BotSession.LOGTAG, e);
                }
                catch (Exception e) {
                    BotLogger.severe(BotSession.LOGTAG, e);
                }
            }
            BotLogger.debug(BotSession.LOGTAG, "Handler thread has being closed");
        }
    }

    private class ReaderThread
    extends Thread {
        private ReaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setPriority(1);
            while (BotSession.this.running) {
                Object url;
                try {
                    GetUpdates request = new GetUpdates();
                    request.setLimit(100);
                    request.setTimeout(50);
                    request.setOffset(BotSession.this.lastReceivedUpdate + 1);
                    url = "https://api.telegram.org/bot" + BotSession.this.token + "/" + "getupdates";
                    HttpPost httpPost = new HttpPost((String)url);
                    httpPost.addHeader("charset", StandardCharsets.UTF_8.name());
                    httpPost.setConfig(BotSession.this.requestConfig);
                    httpPost.setEntity(new StringEntity(request.toJson().toString(), ContentType.APPLICATION_JSON));
                    try {
                        CloseableHttpResponse response = BotSession.this.httpclient.execute(httpPost);
                        Throwable throwable = null;
                        try {
                            HttpEntity ht = response.getEntity();
                            BufferedHttpEntity buf = new BufferedHttpEntity(ht);
                            String responseContent = EntityUtils.toString((HttpEntity)buf, StandardCharsets.UTF_8);
                            try {
                                Object object;
                                JSONObject jsonObject = new JSONObject(responseContent);
                                if (!jsonObject.getBoolean("ok")) {
                                    throw new TelegramApiRequestException("Error getting updates", jsonObject);
                                }
                                JSONArray jsonArray = jsonObject.getJSONArray("result");
                                if (jsonArray.length() != 0) {
                                    for (int i = 0; i < jsonArray.length(); ++i) {
                                        Update update = new Update(jsonArray.getJSONObject(i));
                                        if (update.getUpdateId() <= BotSession.this.lastReceivedUpdate) continue;
                                        BotSession.this.lastReceivedUpdate = update.getUpdateId();
                                        BotSession.this.receivedUpdates.addFirst(update);
                                    }
                                    object = BotSession.this.receivedUpdates;
                                    synchronized (object) {
                                        BotSession.this.receivedUpdates.notifyAll();
                                        continue;
                                    }
                                }
                                object = this;
                                synchronized (object) {
                                    this.wait(500L);
                                }
                            }
                            catch (JSONException e) {
                                BotLogger.severe(responseContent, BotSession.LOGTAG, e);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (response == null) continue;
                            if (throwable != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            response.close();
                        }
                    }
                    catch (InvalidObjectException | TelegramApiRequestException e) {
                        BotLogger.severe(BotSession.LOGTAG, e);
                    }
                }
                catch (InterruptedException e) {
                    if (!BotSession.this.running) {
                        BotSession.this.receivedUpdates.clear();
                    }
                    BotLogger.debug(BotSession.LOGTAG, e);
                }
                catch (Exception global) {
                    BotLogger.severe(BotSession.LOGTAG, global);
                    try {
                        url = this;
                        synchronized (url) {
                            this.wait(500L);
                        }
                    }
                    catch (InterruptedException e) {
                        if (!BotSession.this.running) {
                            BotSession.this.receivedUpdates.clear();
                        }
                        BotLogger.debug(BotSession.LOGTAG, e);
                    }
                }
            }
            BotLogger.debug(BotSession.LOGTAG, "Reader thread has being closed");
        }
    }
}

