/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.updatesreceivers;

import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.telegram.telegrambots.api.objects.Update;
import org.telegram.telegrambots.bots.ITelegramWebhookBot;

@Path(value="callback")
public class RestApi {
    private final ConcurrentHashMap<String, ITelegramWebhookBot> callbacks = new ConcurrentHashMap();

    public void registerCallback(ITelegramWebhookBot callback) {
        if (!this.callbacks.containsKey(callback.getBotPath())) {
            this.callbacks.put(callback.getBotPath(), callback);
        }
    }

    @POST
    @Path(value="/{botPath}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateReceived(@PathParam(value="botPath") String botPath, Update update) {
        if (this.callbacks.containsKey(botPath)) {
            return Response.ok(this.callbacks.get(botPath).onWebhookUpdateReceived(update)).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/{botPath}")
    @Produces(value={"application/json"})
    public String testReceived(@PathParam(value="botPath") String botPath) {
        if (this.callbacks.containsKey(botPath)) {
            return "Hi there " + botPath + "!";
        }
        return "Callback not found for " + botPath;
    }
}

