/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.updatesreceivers;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.telegram.telegrambots.bots.ITelegramWebhookBot;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.updatesreceivers.RestApi;

public class Webhook {
    private final String KEYSTORE_SERVER_FILE;
    private final String KEYSTORE_SERVER_PWD;
    private final RestApi restApi;
    private final String internalUrl;

    public Webhook(String keyStore, String keyStorePassword, String internalUrl) throws TelegramApiRequestException {
        this.KEYSTORE_SERVER_FILE = keyStore;
        this.KEYSTORE_SERVER_PWD = keyStorePassword;
        Webhook.validateServerKeystoreFile(keyStore);
        this.internalUrl = internalUrl;
        this.restApi = new RestApi();
    }

    public void registerWebhook(ITelegramWebhookBot callback) {
        this.restApi.registerCallback(callback);
    }

    public void startServer() throws TelegramApiRequestException {
        SSLContextConfigurator sslContext = new SSLContextConfigurator();
        sslContext.setKeyStoreFile(this.KEYSTORE_SERVER_FILE);
        sslContext.setKeyStorePass(this.KEYSTORE_SERVER_PWD);
        ResourceConfig rc = new ResourceConfig();
        rc.register(this.restApi);
        rc.register((Class)JacksonFeature.class);
        rc.property("com.sun.jersey.api.json.POJOMappingFeature", true);
        HttpServer grizzlyServer = GrizzlyHttpServerFactory.createHttpServer(this.getBaseURI(), rc, true, new SSLEngineConfigurator(sslContext).setClientMode(false).setNeedClientAuth(false));
        try {
            grizzlyServer.start();
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Error starting webhook server", e);
        }
    }

    private URI getBaseURI() {
        return URI.create(this.internalUrl);
    }

    private static void validateServerKeystoreFile(String keyStore) throws TelegramApiRequestException {
        File file = new File(keyStore);
        if (!file.exists() || !file.canRead()) {
            throw new TelegramApiRequestException("Can't find or access server keystore file.");
        }
    }
}

