/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class ForwardMessage
extends BotApiMethod<Message> {
    public static final String PATH = "forwardmessage";
    private static final String CHATID_FIELD = "chat_id";
    private static final String FROMCHATID_FIELD = "from_chat_id";
    private static final String MESSAGEID_FIELD = "message_id";
    private static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    private String chatId;
    private String fromChatId;
    private Integer messageId;
    private Boolean disableNotification;

    public String getChatId() {
        return this.chatId;
    }

    public ForwardMessage setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public String getFromChatId() {
        return this.fromChatId;
    }

    public ForwardMessage setFromChatId(String fromChatId) {
        this.fromChatId = fromChatId;
        return this;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public ForwardMessage setMessageId(Integer messageId) {
        this.messageId = messageId;
        return this;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public ForwardMessage enableNotification() {
        this.disableNotification = false;
        return this;
    }

    public ForwardMessage disableNotification() {
        this.disableNotification = true;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.fromChatId == null) {
            throw new TelegramApiValidationException("FromChatId can't be empty", this);
        }
        if (this.messageId == null) {
            throw new TelegramApiValidationException("MessageId can't be empty", this);
        }
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("method", PATH);
        gen.writeStringField(CHATID_FIELD, this.chatId);
        gen.writeStringField(FROMCHATID_FIELD, this.fromChatId);
        gen.writeNumberField(MESSAGEID_FIELD, this.messageId.intValue());
        if (this.disableNotification != null) {
            gen.writeBooleanField(DISABLENOTIFICATION_FIELD, this.disableNotification.booleanValue());
        }
        gen.writeEndObject();
        gen.flush();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(CHATID_FIELD, (Object)this.chatId);
        jsonObject.put(FROMCHATID_FIELD, (Object)this.fromChatId);
        jsonObject.put(MESSAGEID_FIELD, (Object)this.messageId);
        if (this.disableNotification != null) {
            jsonObject.put(DISABLENOTIFICATION_FIELD, (Object)this.disableNotification);
        }
        return jsonObject;
    }

    @Override
    public String getPath() {
        return PATH;
    }

    @Override
    public Message deserializeResponse(JSONObject answer) {
        if (answer.getBoolean("ok")) {
            return new Message(answer.getJSONObject("result"));
        }
        return null;
    }

    public String toString() {
        return "ForwardMessage{chatId='" + this.chatId + '\'' + ", fromChatId=" + this.fromChatId + ", messageId=" + this.messageId + '}';
    }
}

