/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.File;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class GetFile
extends BotApiMethod<File> {
    public static final String PATH = "getFile";
    private static final String FILEID_FIELD = "file_id";
    private String fileId;

    public String getFileId() {
        return this.fileId;
    }

    public GetFile setFileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.fileId == null) {
            throw new TelegramApiValidationException("FileId can't be empty", this);
        }
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("method", PATH);
        gen.writeStringField(FILEID_FIELD, this.fileId);
        gen.writeEndObject();
        gen.flush();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(FILEID_FIELD, (Object)this.fileId);
        return jsonObject;
    }

    @Override
    public String getPath() {
        return PATH;
    }

    @Override
    public File deserializeResponse(JSONObject answer) {
        if (answer.getBoolean("ok")) {
            return new File(answer.getJSONObject("result"));
        }
        return null;
    }

    public String toString() {
        return "GetFile{fileId='" + this.fileId + '\'' + '}';
    }
}

