/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.games;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.io.Serializable;
import org.json.JSONObject;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class SetGameScore
extends BotApiMethod<Serializable> {
    public static final String PATH = "setGameScore";
    private static final String USER_ID_FIELD = "user_id";
    private static final String SCORE_FIELD = "score";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MESSAGEID_FIELD = "message_id";
    private static final String INLINE_MESSAGE_ID_FIELD = "inline_message_id";
    private static final String EDIT_MESSAGE_FIELD = "edit_message";
    private String chatId;
    private Integer messageId;
    private String inlineMessageId;
    private Boolean editMessage;
    private Integer userId;
    private Integer score;

    public String getChatId() {
        return this.chatId;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    public Boolean getEditMessage() {
        return this.editMessage;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public Integer getScore() {
        return this.score;
    }

    public SetGameScore setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public SetGameScore setMessageId(Integer messageId) {
        this.messageId = messageId;
        return this;
    }

    public SetGameScore setInlineMessageId(String inlineMessageId) {
        this.inlineMessageId = inlineMessageId;
        return this;
    }

    public SetGameScore setEditMessage(Boolean editMessage) {
        this.editMessage = editMessage;
        return this;
    }

    public SetGameScore setUserId(Integer userId) {
        this.userId = userId;
        return this;
    }

    public SetGameScore setScore(Integer score) {
        this.score = score;
        return this;
    }

    @Override
    public String getPath() {
        return PATH;
    }

    @Override
    public Serializable deserializeResponse(JSONObject answer) {
        if (answer.getBoolean("ok")) {
            Object result = answer.get("result");
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            if (result instanceof JSONObject) {
                return new Message((JSONObject)result);
            }
        }
        return null;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.userId == null) {
            throw new TelegramApiValidationException("UserId parameter can't be empty", this);
        }
        if (this.score == null) {
            throw new TelegramApiValidationException("Score parameter can't be empty", this);
        }
        if (this.inlineMessageId == null) {
            if (this.chatId == null) {
                throw new TelegramApiValidationException("ChatId parameter can't be empty if inlineMessageId is not present", this);
            }
            if (this.messageId == null) {
                throw new TelegramApiValidationException("MessageId parameter can't be empty if inlineMessageId is not present", this);
            }
        } else {
            if (this.chatId != null) {
                throw new TelegramApiValidationException("ChatId parameter must be empty if inlineMessageId is provided", this);
            }
            if (this.messageId != null) {
                throw new TelegramApiValidationException("MessageId parameter must be empty if inlineMessageId is provided", this);
            }
        }
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        if (this.chatId != null) {
            gen.writeStringField(CHATID_FIELD, this.chatId);
            gen.writeNumberField(MESSAGEID_FIELD, this.messageId.intValue());
        }
        if (this.inlineMessageId != null) {
            gen.writeStringField(INLINE_MESSAGE_ID_FIELD, this.inlineMessageId);
        }
        if (this.editMessage != null) {
            gen.writeBooleanField(EDIT_MESSAGE_FIELD, this.editMessage.booleanValue());
        }
        gen.writeNumberField(USER_ID_FIELD, this.userId.intValue());
        gen.writeNumberField(SCORE_FIELD, this.score.intValue());
        gen.writeEndObject();
        gen.flush();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        if (this.chatId != null) {
            jsonObject.put(CHATID_FIELD, (Object)this.chatId);
            jsonObject.put(MESSAGEID_FIELD, (Object)this.messageId);
        }
        if (this.inlineMessageId != null) {
            jsonObject.put(INLINE_MESSAGE_ID_FIELD, (Object)this.inlineMessageId);
        }
        if (this.editMessage != null) {
            jsonObject.put(EDIT_MESSAGE_FIELD, (Object)this.editMessage);
        }
        jsonObject.put(USER_ID_FIELD, (Object)this.userId);
        jsonObject.put(SCORE_FIELD, (Object)this.score);
        return jsonObject;
    }

    public String toString() {
        return "SetGameScore{chatId='" + this.chatId + '\'' + ", messageId=" + this.messageId + ", inlineMessageId='" + this.inlineMessageId + '\'' + ", editMessage=" + this.editMessage + ", userId=" + this.userId + ", score=" + this.score + '}';
    }
}

