/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.send;

import java.io.File;
import java.io.InputStream;
import java.util.Objects;
import org.telegram.telegrambots.api.objects.replykeyboard.ReplyKeyboard;

public class SendSticker {
    public static final String PATH = "sendsticker";
    public static final String CHATID_FIELD = "chat_id";
    public static final String STICKER_FIELD = "sticker";
    public static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    public static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    public static final String REPLYMARKUP_FIELD = "reply_markup";
    private String chatId;
    private String sticker;
    private Boolean disableNotification;
    private Integer replyToMessageId;
    private ReplyKeyboard replyMarkup;
    private boolean isNewSticker;
    private String stickerName;
    private File newStickerFile;
    private InputStream newStickerStream;

    public String getChatId() {
        return this.chatId;
    }

    public SendSticker setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public String getSticker() {
        return this.sticker;
    }

    public SendSticker setSticker(String sticker) {
        this.sticker = sticker;
        this.isNewSticker = false;
        return this;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public SendSticker setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
        return this;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public SendSticker setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public SendSticker setNewSticker(File file) {
        this.sticker = file.getName();
        this.isNewSticker = true;
        this.newStickerFile = file;
        return this;
    }

    public SendSticker setNewSticker(String stickerName, InputStream inputStream) {
        Objects.requireNonNull(stickerName, "stickerName cannot be null!");
        Objects.requireNonNull(inputStream, "inputStream cannot be null!");
        this.stickerName = stickerName;
        this.isNewSticker = true;
        this.newStickerStream = inputStream;
        return this;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public SendSticker enableNotification() {
        this.disableNotification = false;
        return this;
    }

    public SendSticker disableNotification() {
        this.disableNotification = true;
        return this;
    }

    public boolean isNewSticker() {
        return this.isNewSticker;
    }

    public String getStickerName() {
        return this.stickerName;
    }

    public File getNewStickerFile() {
        return this.newStickerFile;
    }

    public InputStream getNewStickerStream() {
        return this.newStickerStream;
    }

    public String toString() {
        return "SendSticker{chatId='" + this.chatId + '\'' + ", sticker='" + this.sticker + '\'' + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", isNewSticker=" + this.isNewSticker + '}';
    }
}

