/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.send;

import java.io.File;
import java.io.InputStream;
import java.util.Objects;
import org.telegram.telegrambots.api.objects.replykeyboard.ReplyKeyboard;

public class SendVoice {
    public static final String PATH = "sendvoice";
    public static final String CHATID_FIELD = "chat_id";
    public static final String VOICE_FIELD = "voice";
    public static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    public static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    public static final String REPLYMARKUP_FIELD = "reply_markup";
    public static final String DURATION_FIELD = "duration";
    public static final String CAPTION_FIELD = "caption";
    private String chatId;
    private String voice;
    private Boolean disableNotification;
    private Integer replyToMessageId;
    private ReplyKeyboard replyMarkup;
    private Integer duration;
    private String caption;
    private boolean isNewVoice;
    private String voiceName;
    private File newVoiceFile;
    private InputStream newVoiceStream;

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public SendVoice enableNotification() {
        this.disableNotification = false;
        return this;
    }

    public SendVoice disableNotification() {
        this.disableNotification = true;
        return this;
    }

    public String getChatId() {
        return this.chatId;
    }

    public SendVoice setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public String getVoice() {
        return this.voice;
    }

    public SendVoice setVoice(String voice) {
        this.voice = voice;
        this.isNewVoice = false;
        return this;
    }

    public SendVoice setNewVoice(File file) {
        this.voice = file.getName();
        this.isNewVoice = true;
        this.newVoiceFile = file;
        return this;
    }

    public SendVoice setNewVoice(String voiceName, InputStream inputStream) {
        Objects.requireNonNull(voiceName, "voiceName cannot be null!");
        Objects.requireNonNull(inputStream, "inputStream cannot be null!");
        this.voiceName = voiceName;
        this.isNewVoice = true;
        this.newVoiceStream = inputStream;
        return this;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public SendVoice setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
        return this;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public SendVoice setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public SendVoice setDuration(Integer duration) {
        this.duration = duration;
        return this;
    }

    public boolean isNewVoice() {
        return this.isNewVoice;
    }

    public String getVoiceName() {
        return this.voiceName;
    }

    public File getNewVoiceFile() {
        return this.newVoiceFile;
    }

    public InputStream getNewVoiceStream() {
        return this.newVoiceStream;
    }

    public String getCaption() {
        return this.caption;
    }

    public SendVoice setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    public String toString() {
        return "SendVoice{chatId='" + this.chatId + '\'' + ", voice='" + this.voice + '\'' + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", duration=" + this.duration + ", caption='" + this.caption + '\'' + ", isNewVoice=" + this.isNewVoice + ", voiceName='" + this.voiceName + '\'' + ", newVoiceFile=" + this.newVoiceFile + ", newVoiceStream=" + this.newVoiceStream + '}';
    }
}

