/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;

public class Audio
implements IBotApiObject {
    private static final String FILEID_FIELD = "file_id";
    private static final String DURATION_FIELD = "duration";
    private static final String MIMETYPE_FIELD = "mime_type";
    private static final String FILESIZE_FIELD = "file_size";
    private static final String TITLE_FIELD = "title";
    private static final String PERFORMER_FIELD = "performer";
    @JsonProperty(value="file_id")
    private String fileId;
    @JsonProperty(value="duration")
    private Integer duration;
    @JsonProperty(value="mime_type")
    private String mimeType;
    @JsonProperty(value="file_size")
    private Integer fileSize;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="performer")
    private String performer;

    public Audio() {
    }

    public Audio(JSONObject jsonObject) {
        this.fileId = jsonObject.getString(FILEID_FIELD);
        this.duration = jsonObject.getInt(DURATION_FIELD);
        if (jsonObject.has(MIMETYPE_FIELD)) {
            this.mimeType = jsonObject.getString(MIMETYPE_FIELD);
        }
        if (jsonObject.has(FILEID_FIELD)) {
            this.fileSize = jsonObject.getInt(FILESIZE_FIELD);
        }
        if (jsonObject.has(TITLE_FIELD)) {
            this.title = jsonObject.getString(TITLE_FIELD);
        }
        if (jsonObject.has(PERFORMER_FIELD)) {
            this.performer = jsonObject.getString(PERFORMER_FIELD);
        }
    }

    public String getFileId() {
        return this.fileId;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Integer getFileSize() {
        return this.fileSize;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPerformer() {
        return this.performer;
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FILEID_FIELD, this.fileId);
        gen.writeNumberField(DURATION_FIELD, this.duration.intValue());
        if (this.mimeType != null) {
            gen.writeStringField(MIMETYPE_FIELD, this.mimeType);
        }
        if (this.fileSize != null) {
            gen.writeNumberField(FILESIZE_FIELD, this.fileSize.intValue());
        }
        if (this.title != null) {
            gen.writeStringField(TITLE_FIELD, this.title);
        }
        if (this.performer != null) {
            gen.writeStringField(PERFORMER_FIELD, this.performer);
        }
        gen.writeEndObject();
        gen.flush();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "Audio{fileId='" + this.fileId + '\'' + ", duration=" + this.duration + ", mimeType='" + this.mimeType + '\'' + ", fileSize=" + this.fileSize + ", title='" + this.title + '\'' + ", performer='" + this.performer + '\'' + '}';
    }
}

