/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;

public class Chat
implements IBotApiObject {
    private static final String ID_FIELD = "id";
    private static final String TYPE_FIELD = "type";
    private static final String TITLE_FIELD = "title";
    private static final String FIRSTNAME_FIELD = "first_name";
    private static final String LASTNAME_FIELD = "last_name";
    private static final String USERNAME_FIELD = "username";
    private static final String ALL_MEMBERS_ARE_ADMINISTRATORS_FIELD = "all_members_are_administrators";
    private static final String USERCHATTYPE = "private";
    private static final String GROUPCHATTYPE = "group";
    private static final String CHANNELCHATTYPE = "channel";
    private static final String SUPERGROUPCHATTYPE = "supergroup";
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="first_name")
    private String firstName;
    @JsonProperty(value="last_name")
    private String lastName;
    @JsonProperty(value="username")
    private String userName;
    @JsonProperty(value="all_members_are_administrators")
    private Boolean allMembersAreAdministrators;

    public Chat() {
    }

    public Chat(JSONObject jsonObject) {
        this.id = jsonObject.getLong(ID_FIELD);
        this.type = jsonObject.getString(TYPE_FIELD);
        if (jsonObject.has(TITLE_FIELD)) {
            this.title = jsonObject.getString(TITLE_FIELD);
        }
        if (jsonObject.has(FIRSTNAME_FIELD)) {
            this.firstName = jsonObject.getString(FIRSTNAME_FIELD);
        }
        if (jsonObject.has(LASTNAME_FIELD)) {
            this.lastName = jsonObject.getString(LASTNAME_FIELD);
        }
        if (jsonObject.has(USERNAME_FIELD)) {
            this.userName = jsonObject.getString(USERNAME_FIELD);
        }
        if (jsonObject.has(ALL_MEMBERS_ARE_ADMINISTRATORS_FIELD)) {
            this.allMembersAreAdministrators = jsonObject.getBoolean(ALL_MEMBERS_ARE_ADMINISTRATORS_FIELD);
        }
    }

    public Long getId() {
        return this.id;
    }

    public Boolean isGroupChat() {
        return GROUPCHATTYPE.equals(this.type);
    }

    public Boolean isChannelChat() {
        return CHANNELCHATTYPE.equals(this.type);
    }

    public Boolean isUserChat() {
        return USERCHATTYPE.equals(this.type);
    }

    public Boolean isSuperGroupChat() {
        return SUPERGROUPCHATTYPE.equals(this.type);
    }

    public String getTitle() {
        return this.title;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getUserName() {
        return this.userName;
    }

    public Boolean getAllMembersAreAdministrators() {
        return this.allMembersAreAdministrators;
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeNumberField(ID_FIELD, this.id.longValue());
        gen.writeStringField(TYPE_FIELD, this.type);
        if (this.isUserChat().booleanValue()) {
            if (this.firstName != null) {
                gen.writeStringField(FIRSTNAME_FIELD, this.firstName);
            }
            if (this.lastName != null) {
                gen.writeStringField(LASTNAME_FIELD, this.lastName);
            }
        } else if (this.title != null) {
            gen.writeStringField(TITLE_FIELD, this.title);
        }
        if (!this.isGroupChat().booleanValue() && this.userName != null) {
            gen.writeStringField(USERNAME_FIELD, this.userName);
        }
        if (this.allMembersAreAdministrators != null) {
            gen.writeBooleanField(ALL_MEMBERS_ARE_ADMINISTRATORS_FIELD, this.allMembersAreAdministrators.booleanValue());
        }
        gen.writeEndObject();
        gen.flush();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "Chat{id=" + this.id + ", type='" + this.type + '\'' + ", title='" + this.title + '\'' + ", firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", userName='" + this.userName + '\'' + ", allMembersAreAdministrators=" + this.allMembersAreAdministrators + '}';
    }
}

