/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;

public class Contact
implements IBotApiObject {
    private static final String PHONENUMBER_FIELD = "phone_number";
    private static final String FIRSTNAME_FIELD = "first_name";
    private static final String LASTNAME_FIELD = "last_name";
    private static final String USERID_FIELD = "user_id";
    @JsonProperty(value="phone_number")
    private String phoneNumber;
    @JsonProperty(value="first_name")
    private String firstName;
    @JsonProperty(value="last_name")
    private String lastName;
    @JsonProperty(value="user_id")
    private Integer userID;

    public Contact() {
    }

    public Contact(JSONObject jsonObject) {
        this.phoneNumber = jsonObject.getString(PHONENUMBER_FIELD);
        this.firstName = jsonObject.getString(FIRSTNAME_FIELD);
        if (jsonObject.has(LASTNAME_FIELD)) {
            this.lastName = jsonObject.getString(LASTNAME_FIELD);
        }
        if (jsonObject.has(USERID_FIELD)) {
            this.userID = jsonObject.getInt(USERID_FIELD);
        }
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Integer getUserID() {
        return this.userID;
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(PHONENUMBER_FIELD, this.phoneNumber);
        gen.writeStringField(FIRSTNAME_FIELD, this.firstName);
        if (this.lastName != null) {
            gen.writeStringField(LASTNAME_FIELD, this.lastName);
        }
        if (this.userID != null) {
            gen.writeNumberField(USERID_FIELD, this.userID.intValue());
        }
        gen.writeEndObject();
        gen.flush();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "Contact{phoneNumber='" + this.phoneNumber + '\'' + ", firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", userID=" + this.userID + '}';
    }
}

