/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;
import org.telegram.telegrambots.api.objects.PhotoSize;

public class Document
implements IBotApiObject {
    private static final String FILEID_FIELD = "file_id";
    private static final String THUMB_FIELD = "thumb";
    private static final String FILENAME_FIELD = "file_name";
    private static final String MIMETYPE_FIELD = "mime_type";
    private static final String FILESIZE_FIELD = "file_size";
    @JsonProperty(value="file_id")
    private String fileId;
    @JsonProperty(value="thumb")
    private PhotoSize thumb;
    @JsonProperty(value="file_name")
    private String fileName;
    @JsonProperty(value="mime_type")
    private String mimeType;
    @JsonProperty(value="file_size")
    private Integer fileSize;

    public Document() {
    }

    public Document(JSONObject jsonObject) {
        this.fileId = jsonObject.getString(FILEID_FIELD);
        if (jsonObject.has(THUMB_FIELD)) {
            this.thumb = new PhotoSize(jsonObject.getJSONObject(THUMB_FIELD));
        }
        if (jsonObject.has(FILENAME_FIELD)) {
            this.fileName = jsonObject.getString(FILENAME_FIELD);
        }
        if (jsonObject.has(MIMETYPE_FIELD)) {
            this.mimeType = jsonObject.getString(MIMETYPE_FIELD);
        }
        if (jsonObject.has(FILESIZE_FIELD)) {
            this.fileSize = jsonObject.getInt(FILESIZE_FIELD);
        }
    }

    public String getFileId() {
        return this.fileId;
    }

    public PhotoSize getThumb() {
        return this.thumb;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Integer getFileSize() {
        return this.fileSize;
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FILEID_FIELD, this.fileId);
        gen.writeObjectField(THUMB_FIELD, (Object)this.thumb);
        if (this.fileName != null) {
            gen.writeStringField(FILENAME_FIELD, this.fileName);
        }
        if (this.mimeType != null) {
            gen.writeStringField(MIMETYPE_FIELD, this.mimeType);
        }
        if (this.fileSize != null) {
            gen.writeNumberField(FILESIZE_FIELD, this.fileSize.intValue());
        }
        gen.writeEndObject();
        gen.flush();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "Document{fileId='" + this.fileId + '\'' + ", thumb=" + this.thumb + ", fileName='" + this.fileName + '\'' + ", mimeType='" + this.mimeType + '\'' + ", fileSize=" + this.fileSize + '}';
    }
}

