/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;
import org.telegram.telegrambots.api.objects.Audio;
import org.telegram.telegrambots.api.objects.Chat;
import org.telegram.telegrambots.api.objects.Contact;
import org.telegram.telegrambots.api.objects.Document;
import org.telegram.telegrambots.api.objects.Location;
import org.telegram.telegrambots.api.objects.MessageEntity;
import org.telegram.telegrambots.api.objects.PhotoSize;
import org.telegram.telegrambots.api.objects.Sticker;
import org.telegram.telegrambots.api.objects.User;
import org.telegram.telegrambots.api.objects.Venue;
import org.telegram.telegrambots.api.objects.Video;
import org.telegram.telegrambots.api.objects.Voice;
import org.telegram.telegrambots.api.objects.games.Game;

public class Message
implements IBotApiObject {
    private static final String MESSAGEID_FIELD = "message_id";
    private static final String FROM_FIELD = "from";
    private static final String DATE_FIELD = "date";
    private static final String CHAT_FIELD = "chat";
    private static final String FORWARDFROM_FIELD = "forward_from";
    private static final String FORWARDFROMCHAT_FIELD = "forward_from_chat";
    private static final String FORWARDDATE_FIELD = "forward_date";
    private static final String TEXT_FIELD = "text";
    private static final String ENTITIES_FIELD = "entities";
    private static final String AUDIO_FIELD = "audio";
    private static final String DOCUMENT_FIELD = "document";
    private static final String PHOTO_FIELD = "photo";
    private static final String STICKER_FIELD = "sticker";
    private static final String VIDEO_FIELD = "video";
    private static final String CONTACT_FIELD = "contact";
    private static final String LOCATION_FIELD = "location";
    private static final String VENUE_FIELD = "venue";
    private static final String PINNED_MESSAGE_FIELD = "pinned_message";
    private static final String NEWCHATMEMBER_FIELD = "new_chat_member";
    private static final String LEFTCHATMEMBER_FIELD = "left_chat_member";
    private static final String NEWCHATTITLE_FIELD = "new_chat_title";
    private static final String NEWCHATPHOTO_FIELD = "new_chat_photo";
    private static final String DELETECHATPHOTO_FIELD = "delete_chat_photo";
    private static final String GROUPCHATCREATED_FIELD = "group_chat_created";
    private static final String REPLYTOMESSAGE_FIELD = "reply_to_message";
    private static final String VOICE_FIELD = "voice";
    private static final String CAPTION_FIELD = "caption";
    private static final String SUPERGROUPCREATED_FIELD = "supergroup_chat_created";
    private static final String CHANNELCHATCREATED_FIELD = "channel_chat_created";
    private static final String MIGRATETOCHAT_FIELD = "migrate_to_chat_id";
    private static final String MIGRATEFROMCHAT_FIELD = "migrate_from_chat_id";
    private static final String EDITDATE_FIELD = "edit_date";
    private static final String GAME_FIELD = "game";
    @JsonProperty(value="message_id")
    private Integer messageId;
    @JsonProperty(value="from")
    private User from;
    @JsonProperty(value="date")
    private Integer date;
    @JsonProperty(value="chat")
    private Chat chat;
    @JsonProperty(value="forward_from")
    private User forwardFrom;
    @JsonProperty(value="forward_from_chat")
    private Chat forwardFromChat;
    @JsonProperty(value="forward_date")
    private Integer forwardDate;
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="entities")
    private List<MessageEntity> entities;
    @JsonProperty(value="audio")
    private Audio audio;
    @JsonProperty(value="document")
    private Document document;
    @JsonProperty(value="photo")
    private List<PhotoSize> photo;
    @JsonProperty(value="sticker")
    private Sticker sticker;
    @JsonProperty(value="video")
    private Video video;
    @JsonProperty(value="contact")
    private Contact contact;
    @JsonProperty(value="location")
    private Location location;
    @JsonProperty(value="venue")
    private Venue venue;
    @JsonProperty(value="pinned_message")
    private Message pinnedMessage;
    @JsonProperty(value="new_chat_member")
    private User newChatMember;
    @JsonProperty(value="left_chat_member")
    private User leftChatMember;
    @JsonProperty(value="new_chat_title")
    private String newChatTitle;
    @JsonProperty(value="new_chat_photo")
    private List<PhotoSize> newChatPhoto;
    @JsonProperty(value="delete_chat_photo")
    private Boolean deleteChatPhoto;
    @JsonProperty(value="group_chat_created")
    private Boolean groupchatCreated;
    @JsonProperty(value="reply_to_message")
    private Message replyToMessage;
    @JsonProperty(value="voice")
    private Voice voice;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="supergroup_chat_created")
    private Boolean superGroupCreated;
    @JsonProperty(value="channel_chat_created")
    private Boolean channelChatCreated;
    @JsonProperty(value="migrate_to_chat_id")
    private Long migrateToChatId;
    @JsonProperty(value="migrate_from_chat_id")
    private Long migrateFromChatId;
    @JsonProperty(value="edit_date")
    private Integer editDate;
    @JsonProperty(value="game")
    private Game game;

    public Message() {
    }

    public Message(JSONObject jsonObject) {
        int i;
        this.messageId = jsonObject.getInt(MESSAGEID_FIELD);
        if (jsonObject.has(FROM_FIELD)) {
            this.from = new User(jsonObject.getJSONObject(FROM_FIELD));
        }
        if (jsonObject.has(DATE_FIELD)) {
            this.date = jsonObject.getInt(DATE_FIELD);
        }
        this.chat = new Chat(jsonObject.getJSONObject(CHAT_FIELD));
        if (jsonObject.has(FORWARDFROMCHAT_FIELD)) {
            this.forwardFromChat = new Chat(jsonObject.getJSONObject(FORWARDFROMCHAT_FIELD));
        }
        if (jsonObject.has(FORWARDFROM_FIELD)) {
            this.forwardFrom = new User(jsonObject.getJSONObject(FORWARDFROM_FIELD));
        }
        if (jsonObject.has(FORWARDDATE_FIELD)) {
            this.forwardDate = jsonObject.getInt(FORWARDDATE_FIELD);
        }
        if (jsonObject.has(TEXT_FIELD)) {
            this.text = jsonObject.getString(TEXT_FIELD);
        }
        if (jsonObject.has(ENTITIES_FIELD)) {
            this.entities = new ArrayList<MessageEntity>();
            JSONArray entities = jsonObject.getJSONArray(ENTITIES_FIELD);
            for (i = 0; i < entities.length(); ++i) {
                this.entities.add(new MessageEntity(entities.getJSONObject(i)));
            }
        }
        if (jsonObject.has(AUDIO_FIELD)) {
            this.audio = new Audio(jsonObject.getJSONObject(AUDIO_FIELD));
        }
        if (jsonObject.has(DOCUMENT_FIELD)) {
            this.document = new Document(jsonObject.getJSONObject(DOCUMENT_FIELD));
        }
        if (jsonObject.has(PHOTO_FIELD)) {
            this.photo = new ArrayList<PhotoSize>();
            JSONArray photos = jsonObject.getJSONArray(PHOTO_FIELD);
            for (i = 0; i < photos.length(); ++i) {
                this.photo.add(new PhotoSize(photos.getJSONObject(i)));
            }
        }
        if (jsonObject.has(STICKER_FIELD)) {
            this.sticker = new Sticker(jsonObject.getJSONObject(STICKER_FIELD));
        }
        if (jsonObject.has(VIDEO_FIELD)) {
            this.video = new Video(jsonObject.getJSONObject(VIDEO_FIELD));
        }
        if (jsonObject.has(CONTACT_FIELD)) {
            this.contact = new Contact(jsonObject.getJSONObject(CONTACT_FIELD));
        }
        if (jsonObject.has(LOCATION_FIELD)) {
            this.location = new Location(jsonObject.getJSONObject(LOCATION_FIELD));
        }
        if (jsonObject.has(VENUE_FIELD)) {
            this.venue = new Venue(jsonObject.getJSONObject(VENUE_FIELD));
        }
        if (jsonObject.has(PINNED_MESSAGE_FIELD)) {
            this.pinnedMessage = new Message(jsonObject.getJSONObject(PINNED_MESSAGE_FIELD));
        }
        if (jsonObject.has(VOICE_FIELD)) {
            this.voice = new Voice(jsonObject.getJSONObject(VOICE_FIELD));
        }
        if (jsonObject.has(CAPTION_FIELD)) {
            this.caption = jsonObject.getString(CAPTION_FIELD);
        }
        if (jsonObject.has(NEWCHATMEMBER_FIELD)) {
            this.newChatMember = new User(jsonObject.getJSONObject(NEWCHATMEMBER_FIELD));
        }
        if (jsonObject.has(LEFTCHATMEMBER_FIELD)) {
            this.leftChatMember = new User(jsonObject.getJSONObject(LEFTCHATMEMBER_FIELD));
        }
        if (jsonObject.has(REPLYTOMESSAGE_FIELD)) {
            this.replyToMessage = new Message(jsonObject.getJSONObject(REPLYTOMESSAGE_FIELD));
        }
        if (jsonObject.has(NEWCHATTITLE_FIELD)) {
            this.newChatTitle = jsonObject.getString(NEWCHATTITLE_FIELD);
        }
        if (jsonObject.has(NEWCHATPHOTO_FIELD)) {
            JSONArray photoArray = jsonObject.getJSONArray(NEWCHATPHOTO_FIELD);
            this.newChatPhoto = new ArrayList<PhotoSize>();
            for (i = 0; i < photoArray.length(); ++i) {
                this.newChatPhoto.add(new PhotoSize(photoArray.getJSONObject(i)));
            }
        }
        if (jsonObject.has(DELETECHATPHOTO_FIELD)) {
            this.deleteChatPhoto = true;
        }
        if (jsonObject.has(GROUPCHATCREATED_FIELD)) {
            this.groupchatCreated = true;
        }
        if (jsonObject.has(SUPERGROUPCREATED_FIELD)) {
            this.superGroupCreated = true;
        }
        if (jsonObject.has(CHANNELCHATCREATED_FIELD)) {
            this.channelChatCreated = true;
        }
        if (jsonObject.has(MIGRATETOCHAT_FIELD)) {
            this.migrateToChatId = jsonObject.getLong(MIGRATETOCHAT_FIELD);
        }
        if (jsonObject.has(MIGRATEFROMCHAT_FIELD)) {
            this.migrateFromChatId = jsonObject.getLong(MIGRATEFROMCHAT_FIELD);
        }
        if (jsonObject.has(EDITDATE_FIELD)) {
            this.editDate = jsonObject.getInt(EDITDATE_FIELD);
        }
        if (jsonObject.has(GAME_FIELD)) {
            this.game = new Game(jsonObject.getJSONObject(GAME_FIELD));
        }
        if (this.hasText() && this.entities != null) {
            this.entities.forEach(x -> x.computeText(this.text));
        }
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public User getFrom() {
        return this.from;
    }

    public Integer getDate() {
        return this.date;
    }

    public Chat getChat() {
        return this.chat;
    }

    public User getForwardFrom() {
        return this.forwardFrom;
    }

    public Integer getForwardDate() {
        return this.forwardDate;
    }

    public String getText() {
        return this.text;
    }

    public List<MessageEntity> getEntities() {
        return this.entities;
    }

    public Audio getAudio() {
        return this.audio;
    }

    public Document getDocument() {
        return this.document;
    }

    public List<PhotoSize> getPhoto() {
        return this.photo;
    }

    public Sticker getSticker() {
        return this.sticker;
    }

    public Video getVideo() {
        return this.video;
    }

    public Contact getContact() {
        return this.contact;
    }

    public Location getLocation() {
        return this.location;
    }

    public Venue getVenue() {
        return this.venue;
    }

    public Message getPinnedMessage() {
        return this.pinnedMessage;
    }

    public User getNewChatMember() {
        return this.newChatMember;
    }

    public User getLeftChatMember() {
        return this.leftChatMember;
    }

    public String getNewChatTitle() {
        return this.newChatTitle;
    }

    public List<PhotoSize> getNewChatPhoto() {
        return this.newChatPhoto;
    }

    public Boolean getDeleteChatPhoto() {
        return this.deleteChatPhoto;
    }

    public Boolean getGroupchatCreated() {
        return this.groupchatCreated;
    }

    public Message getReplyToMessage() {
        return this.replyToMessage;
    }

    public Voice getVoice() {
        return this.voice;
    }

    public String getCaption() {
        return this.caption;
    }

    public Boolean getSuperGroupCreated() {
        return this.superGroupCreated;
    }

    public Boolean getChannelChatCreated() {
        return this.channelChatCreated;
    }

    public Long getMigrateToChatId() {
        return this.migrateToChatId;
    }

    public Long getMigrateFromChatId() {
        return this.migrateFromChatId;
    }

    public boolean isGroupMessage() {
        return this.chat.isGroupChat();
    }

    public boolean isUserMessage() {
        return this.chat.isUserChat();
    }

    public boolean isChannelMessage() {
        return this.chat.isChannelChat();
    }

    public boolean isSuperGroupMessage() {
        return this.chat.isSuperGroupChat();
    }

    public Long getChatId() {
        return this.chat.getId();
    }

    public boolean hasText() {
        return this.text != null && !this.text.isEmpty();
    }

    public boolean isCommand() {
        if (this.hasText() && this.entities != null) {
            for (MessageEntity entity : this.entities) {
                if (entity == null || entity.getOffset() != 0 || !"bot_command".equals(entity.getType())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasDocument() {
        return this.document != null;
    }

    public boolean isReply() {
        return this.replyToMessage != null;
    }

    public boolean hasLocation() {
        return this.location != null;
    }

    public Chat getForwardFromChat() {
        return this.forwardFromChat;
    }

    public Integer getEditDate() {
        return this.editDate;
    }

    public Game getGame() {
        return this.game;
    }

    private boolean hasGame() {
        return this.game != null;
    }

    public boolean hasEntities() {
        return this.entities != null && !this.entities.isEmpty();
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeNumberField(MESSAGEID_FIELD, this.messageId.intValue());
        if (this.from != null) {
            gen.writeObjectField(FROM_FIELD, (Object)this.from);
        }
        if (this.date != null) {
            gen.writeNumberField(DATE_FIELD, this.date.intValue());
        }
        gen.writeObjectField(CHAT_FIELD, (Object)this.chat);
        if (this.forwardFromChat != null) {
            gen.writeObjectField(FORWARDFROMCHAT_FIELD, (Object)this.forwardFromChat);
        }
        if (this.forwardFrom != null) {
            gen.writeObjectField(FORWARDFROM_FIELD, (Object)this.forwardFrom);
        }
        if (this.forwardDate != null) {
            gen.writeNumberField(FORWARDDATE_FIELD, this.forwardDate.intValue());
        }
        if (this.text != null) {
            gen.writeStringField(TEXT_FIELD, this.text);
        }
        if (this.audio != null) {
            gen.writeObjectField(AUDIO_FIELD, (Object)this.audio);
        }
        if (this.document != null) {
            gen.writeObjectField(DOCUMENT_FIELD, (Object)this.document);
        }
        if (this.photo != null && this.photo.size() > 0) {
            gen.writeArrayFieldStart(PHOTO_FIELD);
            for (PhotoSize photoSize : this.photo) {
                gen.writeObject((Object)photoSize);
            }
            gen.writeEndArray();
        }
        if (this.sticker != null) {
            gen.writeObjectField(STICKER_FIELD, (Object)this.sticker);
        }
        if (this.video != null) {
            gen.writeObjectField(VIDEO_FIELD, (Object)this.video);
        }
        if (this.contact != null) {
            gen.writeObjectField(CONTACT_FIELD, (Object)this.contact);
        }
        if (this.location != null) {
            gen.writeObjectField(LOCATION_FIELD, (Object)this.location);
        }
        if (this.venue != null) {
            gen.writeObjectField(VENUE_FIELD, (Object)this.venue);
        }
        if (this.voice != null) {
            gen.writeObjectField(VOICE_FIELD, (Object)this.voice);
        }
        if (this.caption != null) {
            gen.writeObjectField(CAPTION_FIELD, (Object)this.caption);
        }
        if (this.newChatMember != null) {
            gen.writeObjectField(NEWCHATMEMBER_FIELD, (Object)this.newChatMember);
        }
        if (this.leftChatMember != null) {
            gen.writeObjectField(LEFTCHATMEMBER_FIELD, (Object)this.leftChatMember);
        }
        if (this.replyToMessage != null) {
            gen.writeObjectField(REPLYTOMESSAGE_FIELD, (Object)this.replyToMessage);
        }
        if (this.newChatTitle != null) {
            gen.writeStringField(NEWCHATTITLE_FIELD, this.newChatTitle);
        }
        if (this.newChatPhoto != null && this.newChatPhoto.size() > 0) {
            gen.writeArrayFieldStart(NEWCHATPHOTO_FIELD);
            for (PhotoSize photoSize : this.newChatPhoto) {
                gen.writeObject((Object)photoSize);
            }
            gen.writeEndArray();
        }
        if (this.deleteChatPhoto != null) {
            gen.writeBooleanField(DELETECHATPHOTO_FIELD, this.deleteChatPhoto.booleanValue());
        }
        if (this.groupchatCreated != null) {
            gen.writeBooleanField(GROUPCHATCREATED_FIELD, this.groupchatCreated.booleanValue());
        }
        if (this.superGroupCreated != null) {
            gen.writeBooleanField(SUPERGROUPCREATED_FIELD, this.superGroupCreated.booleanValue());
        }
        if (this.channelChatCreated != null) {
            gen.writeBooleanField(CHANNELCHATCREATED_FIELD, this.channelChatCreated.booleanValue());
        }
        if (this.migrateToChatId != null) {
            gen.writeNumberField(MIGRATETOCHAT_FIELD, this.migrateToChatId.longValue());
        }
        if (this.migrateFromChatId != null) {
            gen.writeNumberField(MIGRATEFROMCHAT_FIELD, this.migrateFromChatId.longValue());
        }
        if (this.editDate != null) {
            gen.writeNumberField(EDITDATE_FIELD, this.editDate.intValue());
        }
        if (this.game != null) {
            gen.writeObjectField(GAME_FIELD, (Object)this.game);
        }
        if (this.entities != null) {
            gen.writeArrayFieldStart(ENTITIES_FIELD);
            for (MessageEntity entity : this.entities) {
                gen.writeObject((Object)entity);
            }
            gen.writeEndArray();
        }
        gen.writeEndObject();
        gen.flush();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "Message{messageId=" + this.messageId + ", from=" + this.from + ", date=" + this.date + ", chat=" + this.chat + ", forwardFrom=" + this.forwardFrom + ", forwardFromChat=" + this.forwardFromChat + ", forwardDate=" + this.forwardDate + ", text='" + this.text + '\'' + ", entities=" + this.entities + ", audio=" + this.audio + ", document=" + this.document + ", photo=" + this.photo + ", sticker=" + this.sticker + ", video=" + this.video + ", contact=" + this.contact + ", location=" + this.location + ", venue=" + this.venue + ", pinnedMessage=" + this.pinnedMessage + ", newChatMember=" + this.newChatMember + ", leftChatMember=" + this.leftChatMember + ", newChatTitle='" + this.newChatTitle + '\'' + ", newChatPhoto=" + this.newChatPhoto + ", deleteChatPhoto=" + this.deleteChatPhoto + ", groupchatCreated=" + this.groupchatCreated + ", replyToMessage=" + this.replyToMessage + ", voice=" + this.voice + ", caption='" + this.caption + '\'' + ", superGroupCreated=" + this.superGroupCreated + ", channelChatCreated=" + this.channelChatCreated + ", migrateToChatId=" + this.migrateToChatId + ", migrateFromChatId=" + this.migrateFromChatId + ", editDate=" + this.editDate + ", game=" + this.game + '}';
    }
}

