/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;
import org.telegram.telegrambots.api.objects.CallbackQuery;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.api.objects.inlinequery.ChosenInlineQuery;
import org.telegram.telegrambots.api.objects.inlinequery.InlineQuery;

public class Update
implements IBotApiObject {
    private static final String UPDATEID_FIELD = "update_id";
    private static final String MESSAGE_FIELD = "message";
    private static final String INLINEQUERY_FIELD = "inline_query";
    private static final String CHOSENINLINEQUERY_FIELD = "chosen_inline_result";
    private static final String CALLBACKQUERY_FIELD = "callback_query";
    private static final String EDITEDMESSAGE_FIELD = "edited_message";
    @JsonProperty(value="update_id")
    private Integer updateId;
    @JsonProperty(value="message")
    private Message message;
    @JsonProperty(value="inline_query")
    private InlineQuery inlineQuery;
    @JsonProperty(value="chosen_inline_result")
    private ChosenInlineQuery chosenInlineQuery;
    @JsonProperty(value="callback_query")
    private CallbackQuery callbackQuery;
    @JsonProperty(value="edited_message")
    private Message editedMessage;

    public Update() {
    }

    public Update(JSONObject jsonObject) {
        this.updateId = jsonObject.getInt(UPDATEID_FIELD);
        if (jsonObject.has(MESSAGE_FIELD)) {
            this.message = new Message(jsonObject.getJSONObject(MESSAGE_FIELD));
        }
        if (jsonObject.has(INLINEQUERY_FIELD)) {
            this.inlineQuery = new InlineQuery(jsonObject.getJSONObject(INLINEQUERY_FIELD));
        }
        if (jsonObject.has(CHOSENINLINEQUERY_FIELD)) {
            this.chosenInlineQuery = new ChosenInlineQuery(jsonObject.getJSONObject(CHOSENINLINEQUERY_FIELD));
        }
        if (jsonObject.has(CALLBACKQUERY_FIELD)) {
            this.callbackQuery = new CallbackQuery(jsonObject.getJSONObject(CALLBACKQUERY_FIELD));
        }
        if (jsonObject.has(EDITEDMESSAGE_FIELD)) {
            this.editedMessage = new Message(jsonObject.getJSONObject(EDITEDMESSAGE_FIELD));
        }
    }

    public Integer getUpdateId() {
        return this.updateId;
    }

    public Message getMessage() {
        return this.message;
    }

    public InlineQuery getInlineQuery() {
        return this.inlineQuery;
    }

    public ChosenInlineQuery getChosenInlineQuery() {
        return this.chosenInlineQuery;
    }

    public CallbackQuery getCallbackQuery() {
        return this.callbackQuery;
    }

    public Message getEditedMessage() {
        return this.editedMessage;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public boolean hasInlineQuery() {
        return this.inlineQuery != null;
    }

    public boolean hasChosenInlineQuery() {
        return this.chosenInlineQuery != null;
    }

    public boolean hasCallbackQuery() {
        return this.callbackQuery != null;
    }

    public boolean hasEditedMessage() {
        return this.editedMessage != null;
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeNumberField(UPDATEID_FIELD, this.updateId.intValue());
        if (this.message != null) {
            gen.writeObjectField(MESSAGE_FIELD, (Object)this.message);
        }
        if (this.inlineQuery != null) {
            gen.writeObjectField(INLINEQUERY_FIELD, (Object)this.inlineQuery);
        }
        if (this.chosenInlineQuery != null) {
            gen.writeObjectField(CHOSENINLINEQUERY_FIELD, (Object)this.chosenInlineQuery);
        }
        if (this.callbackQuery != null) {
            gen.writeObjectField(CALLBACKQUERY_FIELD, (Object)this.callbackQuery);
        }
        if (this.editedMessage != null) {
            gen.writeObjectField(EDITEDMESSAGE_FIELD, (Object)this.editedMessage);
        }
        gen.writeEndObject();
        gen.flush();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "Update{updateId=" + this.updateId + ", message=" + this.message + ", inlineQuery=" + this.inlineQuery + ", chosenInlineQuery=" + this.chosenInlineQuery + ", callbackQuery=" + this.callbackQuery + ", editedMessage=" + this.editedMessage + '}';
    }
}

