/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;
import org.telegram.telegrambots.api.objects.PhotoSize;

public class Video
implements IBotApiObject {
    private static final String FILEID_FIELD = "file_id";
    private static final String WIDTH_FIELD = "width";
    private static final String HEIGHT_FIELD = "height";
    private static final String DURATION_FIELD = "duration";
    private static final String THUMB_FIELD = "thumb";
    private static final String MIMETYPE_FIELD = "mime_type";
    private static final String FILESIZE_FIELD = "file_size";
    @JsonProperty(value="file_id")
    private String fileId;
    @JsonProperty(value="width")
    private Integer width;
    @JsonProperty(value="height")
    private Integer height;
    @JsonProperty(value="duration")
    private Integer duration;
    @JsonProperty(value="thumb")
    private PhotoSize thumb;
    @JsonProperty(value="mime_type")
    private String mimeType;
    @JsonProperty(value="file_size")
    private Integer fileSize;

    public Video() {
    }

    public Video(JSONObject jsonObject) {
        this.fileId = jsonObject.getString(FILEID_FIELD);
        this.width = jsonObject.getInt(WIDTH_FIELD);
        this.height = jsonObject.getInt(HEIGHT_FIELD);
        this.duration = jsonObject.getInt(DURATION_FIELD);
        if (jsonObject.has(THUMB_FIELD)) {
            this.thumb = new PhotoSize(jsonObject.getJSONObject(THUMB_FIELD));
        }
        if (jsonObject.has(MIMETYPE_FIELD)) {
            this.mimeType = jsonObject.getString(MIMETYPE_FIELD);
        }
        if (jsonObject.has(FILESIZE_FIELD)) {
            this.fileSize = jsonObject.getInt(FILESIZE_FIELD);
        }
    }

    public String getFileId() {
        return this.fileId;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public PhotoSize getThumb() {
        return this.thumb;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Integer getFileSize() {
        return this.fileSize;
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FILEID_FIELD, this.fileId);
        gen.writeNumberField(WIDTH_FIELD, this.width.intValue());
        gen.writeNumberField(HEIGHT_FIELD, this.height.intValue());
        gen.writeNumberField(DURATION_FIELD, this.duration.intValue());
        if (this.thumb != null) {
            gen.writeObjectField(THUMB_FIELD, (Object)this.thumb);
        }
        if (this.mimeType != null) {
            gen.writeStringField(MIMETYPE_FIELD, this.mimeType);
        }
        if (this.fileSize != null) {
            gen.writeNumberField(FILESIZE_FIELD, this.fileSize.intValue());
        }
        gen.writeEndObject();
        gen.flush();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "Video{fileId='" + this.fileId + '\'' + ", width=" + this.width + ", height=" + this.height + ", duration=" + this.duration + ", thumb=" + this.thumb + ", mimeType='" + this.mimeType + '\'' + ", fileSize=" + this.fileSize + '}';
    }
}

