/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;

public class WebhookInfo
implements IBotApiObject {
    private static final String URL_FIELD = "url";
    private static final String HASCUSTOMCERTIFICATE_FIELD = "has_custom_certificate";
    private static final String PENDINGUPDATESCOUNT_FIELD = "pending_updates_count";
    private static final String LASTERRORDATE_FIELD = "last_error_date";
    private static final String LASTERRORMESSAGE_FIELD = "last_error_message";
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="has_custom_certificate")
    private Boolean hasCustomCertificate;
    @JsonProperty(value="pending_updates_count")
    private Integer pendingUpdatesCount;
    @JsonProperty(value="last_error_date")
    private Integer lastErrorDate;
    @JsonProperty(value="last_error_message")
    private String lastErrorMessage;

    public WebhookInfo() {
    }

    public WebhookInfo(JSONObject object) {
        this.url = object.getString(URL_FIELD);
        this.hasCustomCertificate = object.getBoolean(HASCUSTOMCERTIFICATE_FIELD);
        this.pendingUpdatesCount = object.getInt(PENDINGUPDATESCOUNT_FIELD);
        if (object.has(LASTERRORDATE_FIELD)) {
            this.lastErrorDate = object.getInt(LASTERRORDATE_FIELD);
        }
        if (object.has(LASTERRORMESSAGE_FIELD)) {
            this.lastErrorMessage = object.getString(LASTERRORMESSAGE_FIELD);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isHasCustomCertificate() {
        return this.hasCustomCertificate;
    }

    public int getPendingUpdatesCount() {
        return this.pendingUpdatesCount;
    }

    public int getLastErrorDate() {
        return this.lastErrorDate;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(URL_FIELD, this.url);
        gen.writeBooleanField(HASCUSTOMCERTIFICATE_FIELD, this.hasCustomCertificate.booleanValue());
        gen.writeNumberField(PENDINGUPDATESCOUNT_FIELD, this.pendingUpdatesCount.intValue());
        if (this.lastErrorDate != null) {
            gen.writeNumberField(LASTERRORDATE_FIELD, this.lastErrorDate.intValue());
        }
        if (this.lastErrorMessage != null) {
            gen.writeStringField(LASTERRORMESSAGE_FIELD, this.lastErrorMessage);
        }
        gen.writeEndObject();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }
}

