/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects.games;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.interfaces.IBotApiObject;
import org.telegram.telegrambots.api.objects.PhotoSize;

public class Animation
implements IBotApiObject {
    private static final String FILEID_FIELD = "file_id";
    private static final String THUMB_FIELD = "thumb";
    private static final String FILENAME_FIELD = "file_name";
    private static final String MIMETYPE_FIELD = "mime_type";
    private static final String FILESIZE_FIELD = "file_size";
    @JsonProperty(value="file_id")
    private String fileId;
    @JsonProperty(value="thumb")
    private PhotoSize thumb;
    @JsonProperty(value="file_name")
    private String fileName;
    @JsonProperty(value="mime_type")
    private String mimetype;
    @JsonProperty(value="file_size")
    private Integer fileSize;

    public Animation() {
    }

    public Animation(JSONObject object) {
        this.fileId = object.getString(FILEID_FIELD);
        if (object.has(THUMB_FIELD)) {
            this.thumb = new PhotoSize(object.getJSONObject(THUMB_FIELD));
        }
        if (object.has(FILENAME_FIELD)) {
            this.fileName = object.getString(FILENAME_FIELD);
        }
        if (object.has(MIMETYPE_FIELD)) {
            this.mimetype = object.getString(MIMETYPE_FIELD);
        }
        if (object.has(FILESIZE_FIELD)) {
            this.fileSize = object.getInt(FILESIZE_FIELD);
        }
    }

    public String getFileId() {
        return this.fileId;
    }

    public PhotoSize getThumb() {
        return this.thumb;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public Integer getFileSize() {
        return this.fileSize;
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FILEID_FIELD, this.fileId);
        if (this.thumb != null) {
            gen.writeObjectField(THUMB_FIELD, (Object)this.thumb);
        }
        if (this.fileName != null) {
            gen.writeStringField(FILENAME_FIELD, this.fileName);
        }
        if (this.mimetype != null) {
            gen.writeStringField(MIMETYPE_FIELD, this.mimetype);
        }
        if (this.fileSize != null) {
            gen.writeNumberField(FILESIZE_FIELD, this.fileSize.intValue());
        }
        gen.writeEndObject();
        gen.flush();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "Animation{fileId='" + this.fileId + '\'' + ", thumb=" + this.thumb + ", fileName='" + this.fileName + '\'' + ", mimetype='" + this.mimetype + '\'' + ", fileSize=" + this.fileSize + '}';
    }
}

