/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects.inlinequery.inputmessagecontent;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class InputContactMessageContent
implements InputMessageContent {
    private static final String PHONE_NUMBER_FIELD = "phone_number";
    private static final String FIRST_NAME_FIELD = "first_name";
    private static final String LAST_NAME_FIELD = "last_name";
    @JsonProperty(value="phone_number")
    private String phoneNumber;
    @JsonProperty(value="first_name")
    private String firstName;
    @JsonProperty(value="last_name")
    private String lastName;

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public InputContactMessageContent setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public InputContactMessageContent setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String getLastName() {
        return this.lastName;
    }

    public InputContactMessageContent setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.phoneNumber == null || this.phoneNumber.isEmpty()) {
            throw new TelegramApiValidationException("PhoneNumber parameter can't be empty", this);
        }
        if (this.firstName == null || this.firstName.isEmpty()) {
            throw new TelegramApiValidationException("FirstName parameter can't be empty", this);
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(PHONE_NUMBER_FIELD, (Object)this.phoneNumber);
        jsonObject.put(FIRST_NAME_FIELD, (Object)this.firstName);
        if (this.lastName != null) {
            jsonObject.put(LAST_NAME_FIELD, (Object)this.lastName);
        }
        return jsonObject;
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(PHONE_NUMBER_FIELD, this.phoneNumber);
        gen.writeStringField(FIRST_NAME_FIELD, this.firstName);
        if (this.lastName != null) {
            gen.writeStringField(LAST_NAME_FIELD, this.lastName);
        }
        gen.writeEndObject();
        gen.flush();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "InputContactMessageContent{phoneNumber='" + this.phoneNumber + '\'' + ", firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + '}';
    }
}

