/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects.inlinequery.inputmessagecontent;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class InputLocationMessageContent
implements InputMessageContent {
    private static final String LATITUDE_FIELD = "latitude";
    private static final String LONGITUDE_FIELD = "longitude";
    @JsonProperty(value="latitude")
    private Float latitude;
    @JsonProperty(value="longitude")
    private Float longitude;

    public Float getLongitude() {
        return this.longitude;
    }

    public InputLocationMessageContent setLongitude(Float longitude) {
        this.longitude = longitude;
        return this;
    }

    public Float getLatitude() {
        return this.latitude;
    }

    public InputLocationMessageContent setLatitude(Float latitude) {
        this.latitude = latitude;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.latitude == null) {
            throw new TelegramApiValidationException("Latitude parameter can't be empty", this);
        }
        if (this.longitude == null) {
            throw new TelegramApiValidationException("Longitude parameter can't be empty", this);
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(LATITUDE_FIELD, (Object)this.latitude);
        jsonObject.put(LONGITUDE_FIELD, (Object)this.longitude);
        return jsonObject;
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeNumberField(LATITUDE_FIELD, this.latitude.floatValue());
        gen.writeNumberField(LONGITUDE_FIELD, this.longitude.floatValue());
        gen.writeEndObject();
        gen.flush();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "InputLocationMessageContent{latitude='" + this.latitude + '\'' + ", longitude='" + this.longitude + '\'' + '}';
    }
}

