/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects.inlinequery.inputmessagecontent;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class InputTextMessageContent
implements InputMessageContent {
    private static final String MESSAGETEXT_FIELD = "message_text";
    private static final String PARSEMODE_FIELD = "parse_mode";
    private static final String DISABLEWEBPAGEPREVIEW_FIELD = "disable_web_page_preview";
    @JsonProperty(value="message_text")
    private String messageText;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="disable_web_page_preview")
    private Boolean disableWebPagePreview;

    public String getMessageText() {
        return this.messageText;
    }

    public InputTextMessageContent setMessageText(String messageText) {
        this.messageText = messageText;
        return this;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public InputTextMessageContent setParseMode(String parseMode) {
        this.parseMode = parseMode;
        return this;
    }

    public Boolean getDisableWebPagePreview() {
        return this.disableWebPagePreview;
    }

    public InputTextMessageContent setDisableWebPagePreview(Boolean disableWebPagePreview) {
        this.disableWebPagePreview = disableWebPagePreview;
        return this;
    }

    public InputTextMessageContent enableMarkdown(boolean enable) {
        this.parseMode = enable ? "Markdown" : null;
        return this;
    }

    public InputTextMessageContent enableHtml(boolean enable) {
        this.parseMode = enable ? "html" : null;
        return this;
    }

    public InputTextMessageContent disableWebPagePreview() {
        this.disableWebPagePreview = true;
        return this;
    }

    public InputTextMessageContent enableWebPagePreview() {
        this.disableWebPagePreview = null;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.messageText == null || this.messageText.isEmpty()) {
            throw new TelegramApiValidationException("MessageText parameter can't be empty", this);
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(MESSAGETEXT_FIELD, (Object)this.messageText);
        if (this.parseMode != null) {
            jsonObject.put(PARSEMODE_FIELD, (Object)this.parseMode);
        }
        if (this.disableWebPagePreview != null) {
            jsonObject.put(DISABLEWEBPAGEPREVIEW_FIELD, (Object)this.disableWebPagePreview);
        }
        return jsonObject;
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(MESSAGETEXT_FIELD, this.messageText);
        if (this.parseMode != null) {
            gen.writeStringField(PARSEMODE_FIELD, this.parseMode);
        }
        if (this.disableWebPagePreview != null) {
            gen.writeBooleanField(DISABLEWEBPAGEPREVIEW_FIELD, this.disableWebPagePreview.booleanValue());
        }
        gen.writeEndObject();
        gen.flush();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "InputTextMessageContent{, messageText='" + this.messageText + '\'' + ", parseMode='" + this.parseMode + '\'' + ", disableWebPagePreview=" + this.disableWebPagePreview + '}';
    }
}

