/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects.inlinequery.inputmessagecontent;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class InputVenueMessageContent
implements InputMessageContent {
    private static final String LATITUDE_FIELD = "latitude";
    private static final String LONGITUDE_FIELD = "longitude";
    private static final String TITLE_FIELD = "title";
    private static final String ADDRESS_FIELD = "address";
    private static final String FOURSQUARE_ID_FIELD = "foursquare_id";
    @JsonProperty(value="latitude")
    private Float latitude;
    @JsonProperty(value="longitude")
    private Float longitude;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="address")
    private String address;
    @JsonProperty(value="foursquare_id")
    private String foursquareId;

    public Float getLatitude() {
        return this.latitude;
    }

    public InputVenueMessageContent setLatitude(Float latitude) {
        this.latitude = latitude;
        return this;
    }

    public Float getLongitude() {
        return this.longitude;
    }

    public InputVenueMessageContent setLongitude(Float longitude) {
        this.longitude = longitude;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public InputVenueMessageContent setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public InputVenueMessageContent setAddress(String address) {
        this.address = address;
        return this;
    }

    public String getFoursquareId() {
        return this.foursquareId;
    }

    public InputVenueMessageContent setFoursquareId(String foursquareId) {
        this.foursquareId = foursquareId;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.latitude == null) {
            throw new TelegramApiValidationException("Latitude parameter can't be empty", this);
        }
        if (this.longitude == null) {
            throw new TelegramApiValidationException("Longitude parameter can't be empty", this);
        }
        if (this.title == null || this.title.isEmpty()) {
            throw new TelegramApiValidationException("Title parameter can't be empty", this);
        }
        if (this.address == null || this.address.isEmpty()) {
            throw new TelegramApiValidationException("Address parameter can't be empty", this);
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(LATITUDE_FIELD, (Object)this.latitude);
        jsonObject.put(LONGITUDE_FIELD, (Object)this.longitude);
        jsonObject.put(TITLE_FIELD, (Object)this.title);
        jsonObject.put(ADDRESS_FIELD, (Object)this.address);
        if (this.foursquareId != null) {
            jsonObject.put(FOURSQUARE_ID_FIELD, (Object)this.foursquareId);
        }
        return jsonObject;
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeNumberField(LATITUDE_FIELD, this.latitude.floatValue());
        gen.writeNumberField(LONGITUDE_FIELD, this.longitude.floatValue());
        gen.writeStringField(TITLE_FIELD, this.title);
        gen.writeStringField(ADDRESS_FIELD, this.address);
        if (this.foursquareId != null) {
            gen.writeStringField(FOURSQUARE_ID_FIELD, this.foursquareId);
        }
        gen.writeEndObject();
        gen.flush();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "InputVenueMessageContent{latitude='" + this.latitude + '\'' + ", longitude='" + this.longitude + '\'' + ", title='" + this.title + '\'' + ", address='" + this.address + '\'' + ", foursquareId='" + this.foursquareId + '\'' + '}';
    }
}

