/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects.replykeyboard;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class ReplyKeyboardHide
implements ReplyKeyboard {
    private static final String HIDEKEYBOARD_FIELD = "hide_keyboard";
    private static final String SELECTIVE_FIELD = "selective";
    @JsonProperty(value="hide_keyboard")
    private Boolean hideKeyboard;
    @JsonProperty(value="selective")
    private Boolean selective;

    public ReplyKeyboardHide() {
        this.hideKeyboard = true;
    }

    public ReplyKeyboardHide(JSONObject jsonObject) {
        if (jsonObject.has(HIDEKEYBOARD_FIELD)) {
            this.hideKeyboard = jsonObject.getBoolean(HIDEKEYBOARD_FIELD);
        }
        if (jsonObject.has(SELECTIVE_FIELD)) {
            this.selective = jsonObject.getBoolean(SELECTIVE_FIELD);
        }
    }

    public Boolean getHideKeyboard() {
        return this.hideKeyboard;
    }

    public Boolean getSelective() {
        return this.selective;
    }

    public ReplyKeyboardHide setSelective(Boolean selective) {
        this.selective = selective;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.hideKeyboard == null) {
            throw new TelegramApiValidationException("Hidekeyboard parameter can't be null", this);
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(HIDEKEYBOARD_FIELD, (Object)this.hideKeyboard);
        if (this.selective != null) {
            jsonObject.put(SELECTIVE_FIELD, (Object)this.selective);
        }
        return jsonObject;
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeBooleanField(HIDEKEYBOARD_FIELD, this.hideKeyboard.booleanValue());
        if (this.selective != null) {
            gen.writeBooleanField(SELECTIVE_FIELD, this.selective.booleanValue());
        }
        gen.writeEndObject();
        gen.flush();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "ReplyKeyboardHide{hideKeyboard=" + this.hideKeyboard + ", selective=" + this.selective + '}';
    }
}

