/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects.replykeyboard;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.telegram.telegrambots.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.api.objects.replykeyboard.buttons.KeyboardButton;
import org.telegram.telegrambots.api.objects.replykeyboard.buttons.KeyboardRow;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class ReplyKeyboardMarkup
implements ReplyKeyboard {
    private static final String KEYBOARD_FIELD = "keyboard";
    private static final String RESIZEKEYBOARD_FIELD = "resize_keyboard";
    private static final String ONETIMEKEYBOARD_FIELD = "one_time_keyboard";
    private static final String SELECTIVE_FIELD = "selective";
    @JsonProperty(value="keyboard")
    private List<KeyboardRow> keyboard = new ArrayList<KeyboardRow>();
    @JsonProperty(value="resize_keyboard")
    private Boolean resizeKeyboard;
    @JsonProperty(value="one_time_keyboard")
    private Boolean oneTimeKeyboad;
    @JsonProperty(value="selective")
    private Boolean selective;

    public List<KeyboardRow> getKeyboard() {
        return this.keyboard;
    }

    public ReplyKeyboardMarkup setKeyboard(List<KeyboardRow> keyboard) {
        this.keyboard = keyboard;
        return this;
    }

    public Boolean getResizeKeyboard() {
        return this.resizeKeyboard;
    }

    public ReplyKeyboardMarkup setResizeKeyboard(Boolean resizeKeyboard) {
        this.resizeKeyboard = resizeKeyboard;
        return this;
    }

    public Boolean getOneTimeKeyboad() {
        return this.oneTimeKeyboad;
    }

    public ReplyKeyboardMarkup setOneTimeKeyboad(Boolean oneTimeKeyboad) {
        this.oneTimeKeyboad = oneTimeKeyboad;
        return this;
    }

    public Boolean getSelective() {
        return this.selective;
    }

    public ReplyKeyboardMarkup setSelective(Boolean selective) {
        this.selective = selective;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.keyboard == null) {
            throw new TelegramApiValidationException("Keyboard parameter can't be null", this);
        }
        for (KeyboardRow keyboardButtons : this.keyboard) {
            keyboardButtons.validate();
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonkeyboard = new JSONArray();
        for (KeyboardRow innerRow : this.keyboard) {
            JSONArray innerJSONKeyboard = new JSONArray();
            for (KeyboardButton button : innerRow) {
                innerJSONKeyboard.put((Object)button.toJson());
            }
            jsonkeyboard.put((Object)innerJSONKeyboard);
        }
        jsonObject.put(KEYBOARD_FIELD, (Object)jsonkeyboard);
        if (this.oneTimeKeyboad != null) {
            jsonObject.put(ONETIMEKEYBOARD_FIELD, (Object)this.oneTimeKeyboad);
        }
        if (this.resizeKeyboard != null) {
            jsonObject.put(RESIZEKEYBOARD_FIELD, (Object)this.resizeKeyboard);
        }
        if (this.selective != null) {
            jsonObject.put(SELECTIVE_FIELD, (Object)this.selective);
        }
        return jsonObject;
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeArrayFieldStart(KEYBOARD_FIELD);
        for (KeyboardRow innerRow : this.keyboard) {
            gen.writeStartArray();
            for (KeyboardButton button : innerRow) {
                gen.writeObject((Object)button);
            }
            gen.writeEndArray();
        }
        gen.writeEndArray();
        if (this.oneTimeKeyboad != null) {
            gen.writeBooleanField(ONETIMEKEYBOARD_FIELD, this.oneTimeKeyboad.booleanValue());
        }
        if (this.resizeKeyboard != null) {
            gen.writeBooleanField(RESIZEKEYBOARD_FIELD, this.resizeKeyboard.booleanValue());
        }
        if (this.selective != null) {
            gen.writeBooleanField(SELECTIVE_FIELD, this.selective.booleanValue());
        }
        gen.writeEndObject();
        gen.flush();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    public String toString() {
        return "ReplyKeyboardMarkup{keyboard=" + this.keyboard + ", resizeKeyboard=" + this.resizeKeyboard + ", oneTimeKeyboad=" + this.oneTimeKeyboad + ", selective=" + this.selective + '}';
    }
}

